<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FeedProduct StructType
 * @subpackage Structs
 */
class FeedProduct extends AbstractStructBase
{
    /**
     * The identifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $identifier;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $name;
    /**
     * The productCategoryName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $productCategoryName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The price
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var float
     */
    public $price;
    /**
     * The productURL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $productURL;
    /**
     * The imageURL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $imageURL;
    /**
     * The additional
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - arrayType: tns:FeedProductAdditionalElement[]
     * - ref: SOAP-ENC:arrayType
     * @var \StructType\FeedProductAdditionalElement[]
     */
    public $additional;
    /**
     * Constructor method for FeedProduct
     * @uses FeedProduct::setIdentifier()
     * @uses FeedProduct::setName()
     * @uses FeedProduct::setProductCategoryName()
     * @uses FeedProduct::setDescription()
     * @uses FeedProduct::setPrice()
     * @uses FeedProduct::setProductURL()
     * @uses FeedProduct::setImageURL()
     * @uses FeedProduct::setAdditional()
     * @param string $identifier
     * @param string $name
     * @param string $productCategoryName
     * @param string $description
     * @param float $price
     * @param string $productURL
     * @param string $imageURL
     * @param \StructType\FeedProductAdditionalElement[] $additional
     */
    public function __construct($identifier = null, $name = null, $productCategoryName = null, $description = null, $price = null, $productURL = null, $imageURL = null, array $additional = array())
    {
        $this
            ->setIdentifier($identifier)
            ->setName($name)
            ->setProductCategoryName($productCategoryName)
            ->setDescription($description)
            ->setPrice($price)
            ->setProductURL($productURL)
            ->setImageURL($imageURL)
            ->setAdditional($additional);
    }
    /**
     * Get identifier value
     * @return string|null
     */
    public function getIdentifier()
    {
        return $this->identifier;
    }
    /**
     * Set identifier value
     * @param string $identifier
     * @return \StructType\FeedProduct
     */
    public function setIdentifier($identifier = null)
    {
        // validation for constraint: string
        if (!is_null($identifier) && !is_string($identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identifier)), __LINE__);
        }
        $this->identifier = $identifier;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\FeedProduct
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get productCategoryName value
     * @return string|null
     */
    public function getProductCategoryName()
    {
        return $this->productCategoryName;
    }
    /**
     * Set productCategoryName value
     * @param string $productCategoryName
     * @return \StructType\FeedProduct
     */
    public function setProductCategoryName($productCategoryName = null)
    {
        // validation for constraint: string
        if (!is_null($productCategoryName) && !is_string($productCategoryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productCategoryName)), __LINE__);
        }
        $this->productCategoryName = $productCategoryName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\FeedProduct
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\FeedProduct
     */
    public function setPrice($price = null)
    {
        $this->price = $price;
        return $this;
    }
    /**
     * Get productURL value
     * @return string|null
     */
    public function getProductURL()
    {
        return $this->productURL;
    }
    /**
     * Set productURL value
     * @param string $productURL
     * @return \StructType\FeedProduct
     */
    public function setProductURL($productURL = null)
    {
        // validation for constraint: string
        if (!is_null($productURL) && !is_string($productURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productURL)), __LINE__);
        }
        $this->productURL = $productURL;
        return $this;
    }
    /**
     * Get imageURL value
     * @return string|null
     */
    public function getImageURL()
    {
        return $this->imageURL;
    }
    /**
     * Set imageURL value
     * @param string $imageURL
     * @return \StructType\FeedProduct
     */
    public function setImageURL($imageURL = null)
    {
        // validation for constraint: string
        if (!is_null($imageURL) && !is_string($imageURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imageURL)), __LINE__);
        }
        $this->imageURL = $imageURL;
        return $this;
    }
    /**
     * Get additional value
     * @return \StructType\FeedProductAdditionalElement[]|null
     */
    public function getAdditional()
    {
        return $this->additional;
    }
    /**
     * Set additional value
     * @throws \InvalidArgumentException
     * @param \StructType\FeedProductAdditionalElement[] $additional
     * @return \StructType\FeedProduct
     */
    public function setAdditional(array $additional = array())
    {
        foreach ($additional as $feedProductAdditionalItem) {
            // validation for constraint: itemType
            if (!$feedProductAdditionalItem instanceof \StructType\FeedProductAdditionalElement) {
                throw new \InvalidArgumentException(sprintf('The additional property can only contain items of \StructType\FeedProductAdditionalElement, "%s" given', is_object($feedProductAdditionalItem) ? get_class($feedProductAdditionalItem) : gettype($feedProductAdditionalItem)), __LINE__);
            }
        }
        $this->additional = $additional;
        return $this;
    }
    /**
     * Add item to additional value
     * @throws \InvalidArgumentException
     * @param \StructType\FeedProductAdditionalElement $item
     * @return \StructType\FeedProduct
     */
    public function addToAdditional(\StructType\FeedProductAdditionalElement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FeedProductAdditionalElement) {
            throw new \InvalidArgumentException(sprintf('The additional property can only contain items of \StructType\FeedProductAdditionalElement, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->additional[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FeedProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
