<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getAffiliateSites
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AffiliateSiteFilter $options
     * @return \StructType\AffiliateSite[]|bool
     */
    public function getAffiliateSites(\StructType\AffiliateSiteFilter $options)
    {
        try {
            $this->setResult(self::getSoapClient()->getAffiliateSites($options));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAffiliateSiteTypes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \StructType\AffiliateSiteType[]|bool
     */
    public function getAffiliateSiteTypes()
    {
        try {
            $this->setResult(self::getSoapClient()->getAffiliateSiteTypes());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAffiliateSiteCategories
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \StructType\AffiliateSiteCategory[]|bool
     */
    public function getAffiliateSiteCategories()
    {
        try {
            $this->setResult(self::getSoapClient()->getAffiliateSiteCategories());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCampaigns
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $affiliateSiteID
     * @param \StructType\CampaignFilter $options
     * @return \StructType\Campaign[]|bool
     */
    public function getCampaigns($affiliateSiteID, \StructType\CampaignFilter $options)
    {
        try {
            $this->setResult(self::getSoapClient()->getCampaigns($affiliateSiteID, $options));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCampaignCategories
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \StructType\CampaignCategory[]|bool
     */
    public function getCampaignCategories()
    {
        try {
            $this->setResult(self::getSoapClient()->getCampaignCategories());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCampaignCommissionExtended
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $affiliateSiteID
     * @param string $campaignID
     * @return \StructType\CampaignCommissionExtended|bool
     */
    public function getCampaignCommissionExtended($affiliateSiteID, $campaignID)
    {
        try {
            $this->setResult(self::getSoapClient()->getCampaignCommissionExtended($affiliateSiteID, $campaignID));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCampaignNewsItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CampaignNewsItemFilter $options
     * @return \StructType\CampaignNewsItem[]|bool
     */
    public function getCampaignNewsItems(\StructType\CampaignNewsItemFilter $options)
    {
        try {
            $this->setResult(self::getSoapClient()->getCampaignNewsItems($options));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMaterialBannerDimensions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \StructType\MaterialBannerDimension[]|bool
     */
    public function getMaterialBannerDimensions()
    {
        try {
            $this->setResult(self::getSoapClient()->getMaterialBannerDimensions());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMaterialBannerImageItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $affiliateSiteID
     * @param string $materialOutputType
     * @param \StructType\MaterialItemFilter $options
     * @return \StructType\MaterialItem[]|bool
     */
    public function getMaterialBannerImageItems($affiliateSiteID, $materialOutputType, \StructType\MaterialItemFilter $options)
    {
        try {
            $this->setResult(self::getSoapClient()->getMaterialBannerImageItems($affiliateSiteID, $materialOutputType, $options));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMaterialBannerFlashItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $affiliateSiteID
     * @param string $materialOutputType
     * @param \StructType\MaterialItemFilter $options
     * @return \StructType\MaterialItem[]|bool
     */
    public function getMaterialBannerFlashItems($affiliateSiteID, $materialOutputType, \StructType\MaterialItemFilter $options)
    {
        try {
            $this->setResult(self::getSoapClient()->getMaterialBannerFlashItems($affiliateSiteID, $materialOutputType, $options));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMaterialTextItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $affiliateSiteID
     * @param string $materialOutputType
     * @param \StructType\MaterialItemFilter $options
     * @return \StructType\MaterialItem[]|bool
     */
    public function getMaterialTextItems($affiliateSiteID, $materialOutputType, \StructType\MaterialItemFilter $options)
    {
        try {
            $this->setResult(self::getSoapClient()->getMaterialTextItems($affiliateSiteID, $materialOutputType, $options));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMaterialHTMLItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $affiliateSiteID
     * @param string $materialOutputType
     * @param \StructType\MaterialItemFilter $options
     * @return \StructType\MaterialItem[]|bool
     */
    public function getMaterialHTMLItems($affiliateSiteID, $materialOutputType, \StructType\MaterialItemFilter $options)
    {
        try {
            $this->setResult(self::getSoapClient()->getMaterialHTMLItems($affiliateSiteID, $materialOutputType, $options));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMaterialIncentiveVoucherItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $affiliateSiteID
     * @param string $materialOutputType
     * @param \StructType\MaterialItemFilter $options
     * @return \StructType\MaterialItem[]|bool
     */
    public function getMaterialIncentiveVoucherItems($affiliateSiteID, $materialOutputType, \StructType\MaterialItemFilter $options)
    {
        try {
            $this->setResult(self::getSoapClient()->getMaterialIncentiveVoucherItems($affiliateSiteID, $materialOutputType, $options));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMaterialIncentiveOfferItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $affiliateSiteID
     * @param string $materialOutputType
     * @param \StructType\MaterialItemFilter $options
     * @return \StructType\MaterialItem[]|bool
     */
    public function getMaterialIncentiveOfferItems($affiliateSiteID, $materialOutputType, \StructType\MaterialItemFilter $options)
    {
        try {
            $this->setResult(self::getSoapClient()->getMaterialIncentiveOfferItems($affiliateSiteID, $materialOutputType, $options));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getClickTransactions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $affiliateSiteID
     * @param \StructType\ClickTransactionFilter $options
     * @return \StructType\ClickTransaction[]|bool
     */
    public function getClickTransactions($affiliateSiteID, \StructType\ClickTransactionFilter $options)
    {
        try {
            $this->setResult(self::getSoapClient()->getClickTransactions($affiliateSiteID, $options));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getConversionTransactions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $affiliateSiteID
     * @param \StructType\ConversionTransactionFilter $options
     * @return \StructType\ConversionTransaction[]|bool
     */
    public function getConversionTransactions($affiliateSiteID, \StructType\ConversionTransactionFilter $options)
    {
        try {
            $this->setResult(self::getSoapClient()->getConversionTransactions($affiliateSiteID, $options));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getReportAffiliateSite
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $affiliateSiteID
     * @param \StructType\ReportAffiliateSiteFilter $options
     * @return \StructType\ReportData|bool
     */
    public function getReportAffiliateSite($affiliateSiteID, \StructType\ReportAffiliateSiteFilter $options)
    {
        try {
            $this->setResult(self::getSoapClient()->getReportAffiliateSite($affiliateSiteID, $options));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getReportCampaign
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $affiliateSiteID
     * @param \StructType\ReportCampaignFilter $options
     * @return \StructType\ReportCampaignElement[]|bool
     */
    public function getReportCampaign($affiliateSiteID, \StructType\ReportCampaignFilter $options)
    {
        try {
            $this->setResult(self::getSoapClient()->getReportCampaign($affiliateSiteID, $options));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getReportReference
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $affiliateSiteID
     * @param \StructType\ReportReferenceFilter $options
     * @return \StructType\ReportReferenceElement[]|bool
     */
    public function getReportReference($affiliateSiteID, \StructType\ReportReferenceFilter $options)
    {
        try {
            $this->setResult(self::getSoapClient()->getReportReference($affiliateSiteID, $options));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFeeds
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $affiliateSiteID
     * @param \StructType\FeedFilter $options
     * @return \StructType\Feed[]|bool
     */
    public function getFeeds($affiliateSiteID, \StructType\FeedFilter $options)
    {
        try {
            $this->setResult(self::getSoapClient()->getFeeds($affiliateSiteID, $options));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFeedProductCategories
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $affiliateSiteID
     * @param string $feedID
     * @return \StructType\FeedCategory[]|bool
     */
    public function getFeedProductCategories($affiliateSiteID, $feedID)
    {
        try {
            $this->setResult(self::getSoapClient()->getFeedProductCategories($affiliateSiteID, $feedID));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFeedProducts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $affiliateSiteID
     * @param \StructType\FeedProductFilter $options
     * @return \StructType\FeedProduct[]|bool
     */
    public function getFeedProducts($affiliateSiteID, \StructType\FeedProductFilter $options)
    {
        try {
            $this->setResult(self::getSoapClient()->getFeedProducts($affiliateSiteID, $options));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPayments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PaymentFilter $options
     * @return \StructType\Payment[]|bool
     */
    public function getPayments(\StructType\PaymentFilter $options)
    {
        try {
            $this->setResult(self::getSoapClient()->getPayments($options));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAttributions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $conversionTransactionID
     * @return \StructType\Attributions|bool
     */
    public function getAttributions($conversionTransactionID)
    {
        try {
            $this->setResult(self::getSoapClient()->getAttributions($conversionTransactionID));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getTouchpoints
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $conversionTransactionID
     * @return \StructType\Touchpoint[]|bool
     */
    public function getTouchpoints($conversionTransactionID)
    {
        try {
            $this->setResult(self::getSoapClient()->getTouchpoints($conversionTransactionID));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AffiliateSiteCategory[]|\StructType\AffiliateSiteType[]|\StructType\AffiliateSite[]|\StructType\Attributions|\StructType\CampaignCategory[]|\StructType\CampaignCommissionExtended|\StructType\CampaignNewsItem[]|\StructType\Campaign[]|\StructType\ClickTransaction[]|\StructType\ConversionTransaction[]|\StructType\FeedCategory[]|\StructType\FeedProduct[]|\StructType\Feed[]|\StructType\MaterialBannerDimension[]|\StructType\MaterialItem[]|\StructType\Payment[]|\StructType\ReportCampaignElement[]|\StructType\ReportData|\StructType\ReportReferenceElement[]|\StructType\Touchpoint[]
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
