<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReportCampaignFilter StructType
 * @subpackage Structs
 */
class ReportCampaignFilter extends AbstractStructBase
{
    /**
     * The campaignID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $campaignID;
    /**
     * The dateFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $dateFrom;
    /**
     * The dateTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $dateTo;
    /**
     * Constructor method for ReportCampaignFilter
     * @uses ReportCampaignFilter::setCampaignID()
     * @uses ReportCampaignFilter::setDateFrom()
     * @uses ReportCampaignFilter::setDateTo()
     * @param int $campaignID
     * @param string $dateFrom
     * @param string $dateTo
     */
    public function __construct($campaignID = null, $dateFrom = null, $dateTo = null)
    {
        $this
            ->setCampaignID($campaignID)
            ->setDateFrom($dateFrom)
            ->setDateTo($dateTo);
    }
    /**
     * Get campaignID value
     * @return int|null
     */
    public function getCampaignID()
    {
        return $this->campaignID;
    }
    /**
     * Set campaignID value
     * @param int $campaignID
     * @return \StructType\ReportCampaignFilter
     */
    public function setCampaignID($campaignID = null)
    {
        // validation for constraint: int
        if (!is_null($campaignID) && !(is_int($campaignID) || ctype_digit($campaignID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($campaignID, true), gettype($campaignID)), __LINE__);
        }
        $this->campaignID = $campaignID;
        return $this;
    }
    /**
     * Get dateFrom value
     * @return string|null
     */
    public function getDateFrom()
    {
        return $this->dateFrom;
    }
    /**
     * Set dateFrom value
     * @param string $dateFrom
     * @return \StructType\ReportCampaignFilter
     */
    public function setDateFrom($dateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($dateFrom) && !is_string($dateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateFrom, true), gettype($dateFrom)), __LINE__);
        }
        $this->dateFrom = $dateFrom;
        return $this;
    }
    /**
     * Get dateTo value
     * @return string|null
     */
    public function getDateTo()
    {
        return $this->dateTo;
    }
    /**
     * Set dateTo value
     * @param string $dateTo
     * @return \StructType\ReportCampaignFilter
     */
    public function setDateTo($dateTo = null)
    {
        // validation for constraint: string
        if (!is_null($dateTo) && !is_string($dateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTo, true), gettype($dateTo)), __LINE__);
        }
        $this->dateTo = $dateTo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReportCampaignFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
