<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FailedTransaction StructType
 * @subpackage Structs
 */
class FailedTransaction extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $ID;
    /**
     * The characteristic
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $characteristic;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The error
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $error;
    /**
     * The commission
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var float
     */
    public $commission;
    /**
     * The orderAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var float
     */
    public $orderAmount;
    /**
     * The IP
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $IP;
    /**
     * The registrationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $registrationDate;
    /**
     * The trackingMethod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $trackingMethod;
    /**
     * The campaignID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $campaignID;
    /**
     * The campaignName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $campaignName;
    /**
     * The productID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $productID;
    /**
     * The productName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $productName;
    /**
     * The affiliateSiteID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $affiliateSiteID;
    /**
     * The affiliateSiteName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $affiliateSiteName;
    /**
     * The materialID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $materialID;
    /**
     * The materialName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $materialName;
    /**
     * The referenceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $referenceID;
    /**
     * The referenceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $referenceName;
    /**
     * Constructor method for FailedTransaction
     * @uses FailedTransaction::setID()
     * @uses FailedTransaction::setCharacteristic()
     * @uses FailedTransaction::setDescription()
     * @uses FailedTransaction::setError()
     * @uses FailedTransaction::setCommission()
     * @uses FailedTransaction::setOrderAmount()
     * @uses FailedTransaction::setIP()
     * @uses FailedTransaction::setRegistrationDate()
     * @uses FailedTransaction::setTrackingMethod()
     * @uses FailedTransaction::setCampaignID()
     * @uses FailedTransaction::setCampaignName()
     * @uses FailedTransaction::setProductID()
     * @uses FailedTransaction::setProductName()
     * @uses FailedTransaction::setAffiliateSiteID()
     * @uses FailedTransaction::setAffiliateSiteName()
     * @uses FailedTransaction::setMaterialID()
     * @uses FailedTransaction::setMaterialName()
     * @uses FailedTransaction::setReferenceID()
     * @uses FailedTransaction::setReferenceName()
     * @param int $iD
     * @param string $characteristic
     * @param string $description
     * @param string $error
     * @param float $commission
     * @param float $orderAmount
     * @param string $iP
     * @param string $registrationDate
     * @param string $trackingMethod
     * @param int $campaignID
     * @param string $campaignName
     * @param int $productID
     * @param string $productName
     * @param int $affiliateSiteID
     * @param string $affiliateSiteName
     * @param int $materialID
     * @param string $materialName
     * @param int $referenceID
     * @param string $referenceName
     */
    public function __construct($iD = null, $characteristic = null, $description = null, $error = null, $commission = null, $orderAmount = null, $iP = null, $registrationDate = null, $trackingMethod = null, $campaignID = null, $campaignName = null, $productID = null, $productName = null, $affiliateSiteID = null, $affiliateSiteName = null, $materialID = null, $materialName = null, $referenceID = null, $referenceName = null)
    {
        $this
            ->setID($iD)
            ->setCharacteristic($characteristic)
            ->setDescription($description)
            ->setError($error)
            ->setCommission($commission)
            ->setOrderAmount($orderAmount)
            ->setIP($iP)
            ->setRegistrationDate($registrationDate)
            ->setTrackingMethod($trackingMethod)
            ->setCampaignID($campaignID)
            ->setCampaignName($campaignName)
            ->setProductID($productID)
            ->setProductName($productName)
            ->setAffiliateSiteID($affiliateSiteID)
            ->setAffiliateSiteName($affiliateSiteName)
            ->setMaterialID($materialID)
            ->setMaterialName($materialName)
            ->setReferenceID($referenceID)
            ->setReferenceName($referenceName);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\FailedTransaction
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get characteristic value
     * @return string|null
     */
    public function getCharacteristic()
    {
        return $this->characteristic;
    }
    /**
     * Set characteristic value
     * @param string $characteristic
     * @return \StructType\FailedTransaction
     */
    public function setCharacteristic($characteristic = null)
    {
        // validation for constraint: string
        if (!is_null($characteristic) && !is_string($characteristic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($characteristic, true), gettype($characteristic)), __LINE__);
        }
        $this->characteristic = $characteristic;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\FailedTransaction
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get error value
     * @return string|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @param string $error
     * @return \StructType\FailedTransaction
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($error, true), gettype($error)), __LINE__);
        }
        $this->error = $error;
        return $this;
    }
    /**
     * Get commission value
     * @return float|null
     */
    public function getCommission()
    {
        return $this->commission;
    }
    /**
     * Set commission value
     * @param float $commission
     * @return \StructType\FailedTransaction
     */
    public function setCommission($commission = null)
    {
        // validation for constraint: float
        if (!is_null($commission) && !(is_float($commission) || is_numeric($commission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($commission, true), gettype($commission)), __LINE__);
        }
        $this->commission = $commission;
        return $this;
    }
    /**
     * Get orderAmount value
     * @return float|null
     */
    public function getOrderAmount()
    {
        return $this->orderAmount;
    }
    /**
     * Set orderAmount value
     * @param float $orderAmount
     * @return \StructType\FailedTransaction
     */
    public function setOrderAmount($orderAmount = null)
    {
        // validation for constraint: float
        if (!is_null($orderAmount) && !(is_float($orderAmount) || is_numeric($orderAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($orderAmount, true), gettype($orderAmount)), __LINE__);
        }
        $this->orderAmount = $orderAmount;
        return $this;
    }
    /**
     * Get IP value
     * @return string|null
     */
    public function getIP()
    {
        return $this->IP;
    }
    /**
     * Set IP value
     * @param string $iP
     * @return \StructType\FailedTransaction
     */
    public function setIP($iP = null)
    {
        // validation for constraint: string
        if (!is_null($iP) && !is_string($iP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iP, true), gettype($iP)), __LINE__);
        }
        $this->IP = $iP;
        return $this;
    }
    /**
     * Get registrationDate value
     * @return string|null
     */
    public function getRegistrationDate()
    {
        return $this->registrationDate;
    }
    /**
     * Set registrationDate value
     * @param string $registrationDate
     * @return \StructType\FailedTransaction
     */
    public function setRegistrationDate($registrationDate = null)
    {
        // validation for constraint: string
        if (!is_null($registrationDate) && !is_string($registrationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registrationDate, true), gettype($registrationDate)), __LINE__);
        }
        $this->registrationDate = $registrationDate;
        return $this;
    }
    /**
     * Get trackingMethod value
     * @return string|null
     */
    public function getTrackingMethod()
    {
        return $this->trackingMethod;
    }
    /**
     * Set trackingMethod value
     * @param string $trackingMethod
     * @return \StructType\FailedTransaction
     */
    public function setTrackingMethod($trackingMethod = null)
    {
        // validation for constraint: string
        if (!is_null($trackingMethod) && !is_string($trackingMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingMethod, true), gettype($trackingMethod)), __LINE__);
        }
        $this->trackingMethod = $trackingMethod;
        return $this;
    }
    /**
     * Get campaignID value
     * @return int|null
     */
    public function getCampaignID()
    {
        return $this->campaignID;
    }
    /**
     * Set campaignID value
     * @param int $campaignID
     * @return \StructType\FailedTransaction
     */
    public function setCampaignID($campaignID = null)
    {
        // validation for constraint: int
        if (!is_null($campaignID) && !(is_int($campaignID) || ctype_digit($campaignID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($campaignID, true), gettype($campaignID)), __LINE__);
        }
        $this->campaignID = $campaignID;
        return $this;
    }
    /**
     * Get campaignName value
     * @return string|null
     */
    public function getCampaignName()
    {
        return $this->campaignName;
    }
    /**
     * Set campaignName value
     * @param string $campaignName
     * @return \StructType\FailedTransaction
     */
    public function setCampaignName($campaignName = null)
    {
        // validation for constraint: string
        if (!is_null($campaignName) && !is_string($campaignName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($campaignName, true), gettype($campaignName)), __LINE__);
        }
        $this->campaignName = $campaignName;
        return $this;
    }
    /**
     * Get productID value
     * @return int|null
     */
    public function getProductID()
    {
        return $this->productID;
    }
    /**
     * Set productID value
     * @param int $productID
     * @return \StructType\FailedTransaction
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: int
        if (!is_null($productID) && !(is_int($productID) || ctype_digit($productID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productID, true), gettype($productID)), __LINE__);
        }
        $this->productID = $productID;
        return $this;
    }
    /**
     * Get productName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->productName;
    }
    /**
     * Set productName value
     * @param string $productName
     * @return \StructType\FailedTransaction
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productName, true), gettype($productName)), __LINE__);
        }
        $this->productName = $productName;
        return $this;
    }
    /**
     * Get affiliateSiteID value
     * @return int|null
     */
    public function getAffiliateSiteID()
    {
        return $this->affiliateSiteID;
    }
    /**
     * Set affiliateSiteID value
     * @param int $affiliateSiteID
     * @return \StructType\FailedTransaction
     */
    public function setAffiliateSiteID($affiliateSiteID = null)
    {
        // validation for constraint: int
        if (!is_null($affiliateSiteID) && !(is_int($affiliateSiteID) || ctype_digit($affiliateSiteID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($affiliateSiteID, true), gettype($affiliateSiteID)), __LINE__);
        }
        $this->affiliateSiteID = $affiliateSiteID;
        return $this;
    }
    /**
     * Get affiliateSiteName value
     * @return string|null
     */
    public function getAffiliateSiteName()
    {
        return $this->affiliateSiteName;
    }
    /**
     * Set affiliateSiteName value
     * @param string $affiliateSiteName
     * @return \StructType\FailedTransaction
     */
    public function setAffiliateSiteName($affiliateSiteName = null)
    {
        // validation for constraint: string
        if (!is_null($affiliateSiteName) && !is_string($affiliateSiteName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($affiliateSiteName, true), gettype($affiliateSiteName)), __LINE__);
        }
        $this->affiliateSiteName = $affiliateSiteName;
        return $this;
    }
    /**
     * Get materialID value
     * @return int|null
     */
    public function getMaterialID()
    {
        return $this->materialID;
    }
    /**
     * Set materialID value
     * @param int $materialID
     * @return \StructType\FailedTransaction
     */
    public function setMaterialID($materialID = null)
    {
        // validation for constraint: int
        if (!is_null($materialID) && !(is_int($materialID) || ctype_digit($materialID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($materialID, true), gettype($materialID)), __LINE__);
        }
        $this->materialID = $materialID;
        return $this;
    }
    /**
     * Get materialName value
     * @return string|null
     */
    public function getMaterialName()
    {
        return $this->materialName;
    }
    /**
     * Set materialName value
     * @param string $materialName
     * @return \StructType\FailedTransaction
     */
    public function setMaterialName($materialName = null)
    {
        // validation for constraint: string
        if (!is_null($materialName) && !is_string($materialName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($materialName, true), gettype($materialName)), __LINE__);
        }
        $this->materialName = $materialName;
        return $this;
    }
    /**
     * Get referenceID value
     * @return int|null
     */
    public function getReferenceID()
    {
        return $this->referenceID;
    }
    /**
     * Set referenceID value
     * @param int $referenceID
     * @return \StructType\FailedTransaction
     */
    public function setReferenceID($referenceID = null)
    {
        // validation for constraint: int
        if (!is_null($referenceID) && !(is_int($referenceID) || ctype_digit($referenceID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($referenceID, true), gettype($referenceID)), __LINE__);
        }
        $this->referenceID = $referenceID;
        return $this;
    }
    /**
     * Get referenceName value
     * @return string|null
     */
    public function getReferenceName()
    {
        return $this->referenceName;
    }
    /**
     * Set referenceName value
     * @param string $referenceName
     * @return \StructType\FailedTransaction
     */
    public function setReferenceName($referenceName = null)
    {
        // validation for constraint: string
        if (!is_null($referenceName) && !is_string($referenceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceName, true), gettype($referenceName)), __LINE__);
        }
        $this->referenceName = $referenceName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FailedTransaction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
