<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AffiliateSitesPaidOut StructType
 * @subpackage Structs
 */
class AffiliateSitesPaidOut extends AbstractStructBase
{
    /**
     * The affiliateSites
     * Meta information extracted from the WSDL
     * - arrayType: tns:AffiliateSitePaidOutElement[]
     * - base: SOAP-ENC:Array
     * - maxOccurs: 1
     * - ref: SOAP-ENC:arrayType
     * @var \StructType\AffiliateSitePaidOutElement[]
     */
    public $affiliateSites;
    /**
     * Constructor method for AffiliateSitesPaidOut
     * @uses AffiliateSitesPaidOut::setAffiliateSites()
     * @param \StructType\AffiliateSitePaidOutElement[] $affiliateSites
     */
    public function __construct(array $affiliateSites = array())
    {
        $this
            ->setAffiliateSites($affiliateSites);
    }
    /**
     * Get affiliateSites value
     * @return \StructType\AffiliateSitePaidOutElement[]|null
     */
    public function getAffiliateSites()
    {
        return $this->affiliateSites;
    }
    /**
     * This method is responsible for validating the values passed to the setAffiliateSites method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAffiliateSites method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAffiliateSitesForArrayConstraintsFromSetAffiliateSites(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $affiliateSitesPaidOutAffiliateSitesItem) {
            // validation for constraint: itemType
            if (!$affiliateSitesPaidOutAffiliateSitesItem instanceof \StructType\AffiliateSitePaidOutElement) {
                $invalidValues[] = is_object($affiliateSitesPaidOutAffiliateSitesItem) ? get_class($affiliateSitesPaidOutAffiliateSitesItem) : sprintf('%s(%s)', gettype($affiliateSitesPaidOutAffiliateSitesItem), var_export($affiliateSitesPaidOutAffiliateSitesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The affiliateSites property can only contain items of type \StructType\AffiliateSitePaidOutElement, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set affiliateSites value
     * @throws \InvalidArgumentException
     * @param \StructType\AffiliateSitePaidOutElement[] $affiliateSites
     * @return \StructType\AffiliateSitesPaidOut
     */
    public function setAffiliateSites(array $affiliateSites = array())
    {
        // validation for constraint: array
        if ('' !== ($affiliateSitesArrayErrorMessage = self::validateAffiliateSitesForArrayConstraintsFromSetAffiliateSites($affiliateSites))) {
            throw new \InvalidArgumentException($affiliateSitesArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($affiliateSites) && count($affiliateSites) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1', count($affiliateSites)), __LINE__);
        }
        $this->affiliateSites = $affiliateSites;
        return $this;
    }
    /**
     * Add item to affiliateSites value
     * @throws \InvalidArgumentException
     * @param \StructType\AffiliateSitePaidOutElement $item
     * @return \StructType\AffiliateSitesPaidOut
     */
    public function addToAffiliateSites(\StructType\AffiliateSitePaidOutElement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AffiliateSitePaidOutElement) {
            throw new \InvalidArgumentException(sprintf('The affiliateSites property can only contain items of type \StructType\AffiliateSitePaidOutElement, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($this->affiliateSites) && count($this->affiliateSites) >= 1) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1', count($this->affiliateSites)), __LINE__);
        }
        $this->affiliateSites[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AffiliateSitesPaidOut
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
