<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReportReferenceElement StructType
 * @subpackage Structs
 */
class ReportReferenceElement extends AbstractStructBase
{
    /**
     * The reference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $reference;
    /**
     * The campaign
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var \StructType\Campaign
     */
    public $campaign;
    /**
     * The reportData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var \StructType\ReportData
     */
    public $reportData;
    /**
     * Constructor method for ReportReferenceElement
     * @uses ReportReferenceElement::setReference()
     * @uses ReportReferenceElement::setCampaign()
     * @uses ReportReferenceElement::setReportData()
     * @param string $reference
     * @param \StructType\Campaign $campaign
     * @param \StructType\ReportData $reportData
     */
    public function __construct($reference = null, \StructType\Campaign $campaign = null, \StructType\ReportData $reportData = null)
    {
        $this
            ->setReference($reference)
            ->setCampaign($campaign)
            ->setReportData($reportData);
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \StructType\ReportReferenceElement
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get campaign value
     * @return \StructType\Campaign|null
     */
    public function getCampaign()
    {
        return $this->campaign;
    }
    /**
     * Set campaign value
     * @param \StructType\Campaign $campaign
     * @return \StructType\ReportReferenceElement
     */
    public function setCampaign(\StructType\Campaign $campaign = null)
    {
        $this->campaign = $campaign;
        return $this;
    }
    /**
     * Get reportData value
     * @return \StructType\ReportData|null
     */
    public function getReportData()
    {
        return $this->reportData;
    }
    /**
     * Set reportData value
     * @param \StructType\ReportData $reportData
     * @return \StructType\ReportReferenceElement
     */
    public function setReportData(\StructType\ReportData $reportData = null)
    {
        $this->reportData = $reportData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReportReferenceElement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
