<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AffiliateSitePaidOutElement StructType
 * @subpackage Structs
 */
class AffiliateSitePaidOutElement extends AbstractStructBase
{
    /**
     * The affiliateSiteID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $affiliateSiteID;
    /**
     * The paidOut
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var bool
     */
    public $paidOut;
    /**
     * Constructor method for AffiliateSitePaidOutElement
     * @uses AffiliateSitePaidOutElement::setAffiliateSiteID()
     * @uses AffiliateSitePaidOutElement::setPaidOut()
     * @param int $affiliateSiteID
     * @param bool $paidOut
     */
    public function __construct($affiliateSiteID = null, $paidOut = null)
    {
        $this
            ->setAffiliateSiteID($affiliateSiteID)
            ->setPaidOut($paidOut);
    }
    /**
     * Get affiliateSiteID value
     * @return int|null
     */
    public function getAffiliateSiteID()
    {
        return $this->affiliateSiteID;
    }
    /**
     * Set affiliateSiteID value
     * @param int $affiliateSiteID
     * @return \StructType\AffiliateSitePaidOutElement
     */
    public function setAffiliateSiteID($affiliateSiteID = null)
    {
        // validation for constraint: int
        if (!is_null($affiliateSiteID) && !(is_int($affiliateSiteID) || ctype_digit($affiliateSiteID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($affiliateSiteID, true), gettype($affiliateSiteID)), __LINE__);
        }
        $this->affiliateSiteID = $affiliateSiteID;
        return $this;
    }
    /**
     * Get paidOut value
     * @return bool|null
     */
    public function getPaidOut()
    {
        return $this->paidOut;
    }
    /**
     * Set paidOut value
     * @param bool $paidOut
     * @return \StructType\AffiliateSitePaidOutElement
     */
    public function setPaidOut($paidOut = null)
    {
        // validation for constraint: boolean
        if (!is_null($paidOut) && !is_bool($paidOut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($paidOut, true), gettype($paidOut)), __LINE__);
        }
        $this->paidOut = $paidOut;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AffiliateSitePaidOutElement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
