<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MaterialBannerDimension StructType
 * @subpackage Structs
 */
class MaterialBannerDimension extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $ID;
    /**
     * The width
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $width;
    /**
     * The height
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $height;
    /**
     * The isCommon
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var bool
     */
    public $isCommon;
    /**
     * The isMobile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var bool
     */
    public $isMobile;
    /**
     * Constructor method for MaterialBannerDimension
     * @uses MaterialBannerDimension::setID()
     * @uses MaterialBannerDimension::setWidth()
     * @uses MaterialBannerDimension::setHeight()
     * @uses MaterialBannerDimension::setIsCommon()
     * @uses MaterialBannerDimension::setIsMobile()
     * @param int $iD
     * @param int $width
     * @param int $height
     * @param bool $isCommon
     * @param bool $isMobile
     */
    public function __construct($iD = null, $width = null, $height = null, $isCommon = null, $isMobile = null)
    {
        $this
            ->setID($iD)
            ->setWidth($width)
            ->setHeight($height)
            ->setIsCommon($isCommon)
            ->setIsMobile($isMobile);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\MaterialBannerDimension
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get width value
     * @return int|null
     */
    public function getWidth()
    {
        return $this->width;
    }
    /**
     * Set width value
     * @param int $width
     * @return \StructType\MaterialBannerDimension
     */
    public function setWidth($width = null)
    {
        // validation for constraint: int
        if (!is_null($width) && !(is_int($width) || ctype_digit($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        $this->width = $width;
        return $this;
    }
    /**
     * Get height value
     * @return int|null
     */
    public function getHeight()
    {
        return $this->height;
    }
    /**
     * Set height value
     * @param int $height
     * @return \StructType\MaterialBannerDimension
     */
    public function setHeight($height = null)
    {
        // validation for constraint: int
        if (!is_null($height) && !(is_int($height) || ctype_digit($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        $this->height = $height;
        return $this;
    }
    /**
     * Get isCommon value
     * @return bool|null
     */
    public function getIsCommon()
    {
        return $this->isCommon;
    }
    /**
     * Set isCommon value
     * @param bool $isCommon
     * @return \StructType\MaterialBannerDimension
     */
    public function setIsCommon($isCommon = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCommon) && !is_bool($isCommon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCommon, true), gettype($isCommon)), __LINE__);
        }
        $this->isCommon = $isCommon;
        return $this;
    }
    /**
     * Get isMobile value
     * @return bool|null
     */
    public function getIsMobile()
    {
        return $this->isMobile;
    }
    /**
     * Set isMobile value
     * @param bool $isMobile
     * @return \StructType\MaterialBannerDimension
     */
    public function setIsMobile($isMobile = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMobile) && !is_bool($isMobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMobile, true), gettype($isMobile)), __LINE__);
        }
        $this->isMobile = $isMobile;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MaterialBannerDimension
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
