<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FailedTransactionFilter StructType
 * @subpackage Structs
 */
class FailedTransactionFilter extends AbstractStructBase
{
    /**
     * The transactionType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $transactionType;
    /**
     * The characteristic
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $characteristic;
    /**
     * The registrationDateFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $registrationDateFrom;
    /**
     * The registrationDateTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $registrationDateTo;
    /**
     * The limit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $limit;
    /**
     * The offset
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $offset;
    /**
     * Constructor method for FailedTransactionFilter
     * @uses FailedTransactionFilter::setTransactionType()
     * @uses FailedTransactionFilter::setCharacteristic()
     * @uses FailedTransactionFilter::setRegistrationDateFrom()
     * @uses FailedTransactionFilter::setRegistrationDateTo()
     * @uses FailedTransactionFilter::setLimit()
     * @uses FailedTransactionFilter::setOffset()
     * @param string $transactionType
     * @param string $characteristic
     * @param string $registrationDateFrom
     * @param string $registrationDateTo
     * @param int $limit
     * @param int $offset
     */
    public function __construct($transactionType = null, $characteristic = null, $registrationDateFrom = null, $registrationDateTo = null, $limit = null, $offset = null)
    {
        $this
            ->setTransactionType($transactionType)
            ->setCharacteristic($characteristic)
            ->setRegistrationDateFrom($registrationDateFrom)
            ->setRegistrationDateTo($registrationDateTo)
            ->setLimit($limit)
            ->setOffset($offset);
    }
    /**
     * Get transactionType value
     * @return string|null
     */
    public function getTransactionType()
    {
        return $this->transactionType;
    }
    /**
     * Set transactionType value
     * @uses \EnumType\TransactionType::valueIsValid()
     * @uses \EnumType\TransactionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionType
     * @return \StructType\FailedTransactionFilter
     */
    public function setTransactionType($transactionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransactionType::valueIsValid($transactionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransactionType', is_array($transactionType) ? implode(', ', $transactionType) : var_export($transactionType, true), implode(', ', \EnumType\TransactionType::getValidValues())), __LINE__);
        }
        $this->transactionType = $transactionType;
        return $this;
    }
    /**
     * Get characteristic value
     * @return string|null
     */
    public function getCharacteristic()
    {
        return $this->characteristic;
    }
    /**
     * Set characteristic value
     * @param string $characteristic
     * @return \StructType\FailedTransactionFilter
     */
    public function setCharacteristic($characteristic = null)
    {
        // validation for constraint: string
        if (!is_null($characteristic) && !is_string($characteristic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($characteristic, true), gettype($characteristic)), __LINE__);
        }
        $this->characteristic = $characteristic;
        return $this;
    }
    /**
     * Get registrationDateFrom value
     * @return string|null
     */
    public function getRegistrationDateFrom()
    {
        return $this->registrationDateFrom;
    }
    /**
     * Set registrationDateFrom value
     * @param string $registrationDateFrom
     * @return \StructType\FailedTransactionFilter
     */
    public function setRegistrationDateFrom($registrationDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($registrationDateFrom) && !is_string($registrationDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registrationDateFrom, true), gettype($registrationDateFrom)), __LINE__);
        }
        $this->registrationDateFrom = $registrationDateFrom;
        return $this;
    }
    /**
     * Get registrationDateTo value
     * @return string|null
     */
    public function getRegistrationDateTo()
    {
        return $this->registrationDateTo;
    }
    /**
     * Set registrationDateTo value
     * @param string $registrationDateTo
     * @return \StructType\FailedTransactionFilter
     */
    public function setRegistrationDateTo($registrationDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($registrationDateTo) && !is_string($registrationDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registrationDateTo, true), gettype($registrationDateTo)), __LINE__);
        }
        $this->registrationDateTo = $registrationDateTo;
        return $this;
    }
    /**
     * Get limit value
     * @return int|null
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param int $limit
     * @return \StructType\FailedTransactionFilter
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !(is_int($limit) || ctype_digit($limit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($limit, true), gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Get offset value
     * @return int|null
     */
    public function getOffset()
    {
        return $this->offset;
    }
    /**
     * Set offset value
     * @param int $offset
     * @return \StructType\FailedTransactionFilter
     */
    public function setOffset($offset = null)
    {
        // validation for constraint: int
        if (!is_null($offset) && !(is_int($offset) || ctype_digit($offset))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($offset, true), gettype($offset)), __LINE__);
        }
        $this->offset = $offset;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FailedTransactionFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
