<?php

namespace EnumType;

/**
 * This class stands for TransactionRejectionReason EnumType
 * @subpackage Enumerations
 */
class TransactionRejectionReason
{
    /**
     * Constant for value 'returned_goods'
     * @return string 'returned_goods'
     */
    const VALUE_RETURNED_GOODS = 'returned_goods';
    /**
     * Constant for value 'out_of_stock'
     * @return string 'out_of_stock'
     */
    const VALUE_OUT_OF_STOCK = 'out_of_stock';
    /**
     * Constant for value 'payment_not_received'
     * @return string 'payment_not_received'
     */
    const VALUE_PAYMENT_NOT_RECEIVED = 'payment_not_received';
    /**
     * Constant for value 'invalid_transaction'
     * @return string 'invalid_transaction'
     */
    const VALUE_INVALID_TRANSACTION = 'invalid_transaction';
    /**
     * Constant for value 'order_canceled'
     * @return string 'order_canceled'
     */
    const VALUE_ORDER_CANCELED = 'order_canceled';
    /**
     * Constant for value 'duplicate_order'
     * @return string 'duplicate_order'
     */
    const VALUE_DUPLICATE_ORDER = 'duplicate_order';
    /**
     * Constant for value 'test_transaction'
     * @return string 'test_transaction'
     */
    const VALUE_TEST_TRANSACTION = 'test_transaction';
    /**
     * Constant for value 'attributed_to_other_channel'
     * @return string 'attributed_to_other_channel'
     */
    const VALUE_ATTRIBUTED_TO_OTHER_CHANNEL = 'attributed_to_other_channel';
    /**
     * Constant for value 'violates_campaign_terms'
     * @return string 'violates_campaign_terms'
     */
    const VALUE_VIOLATES_CAMPAIGN_TERMS = 'violates_campaign_terms';
    /**
     * Constant for value 'invalid_customer_details'
     * @return string 'invalid_customer_details'
     */
    const VALUE_INVALID_CUSTOMER_DETAILS = 'invalid_customer_details';
    /**
     * Constant for value 'customer_unreachable'
     * @return string 'customer_unreachable'
     */
    const VALUE_CUSTOMER_UNREACHABLE = 'customer_unreachable';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_RETURNED_GOODS
     * @uses self::VALUE_OUT_OF_STOCK
     * @uses self::VALUE_PAYMENT_NOT_RECEIVED
     * @uses self::VALUE_INVALID_TRANSACTION
     * @uses self::VALUE_ORDER_CANCELED
     * @uses self::VALUE_DUPLICATE_ORDER
     * @uses self::VALUE_TEST_TRANSACTION
     * @uses self::VALUE_ATTRIBUTED_TO_OTHER_CHANNEL
     * @uses self::VALUE_VIOLATES_CAMPAIGN_TERMS
     * @uses self::VALUE_INVALID_CUSTOMER_DETAILS
     * @uses self::VALUE_CUSTOMER_UNREACHABLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_RETURNED_GOODS,
            self::VALUE_OUT_OF_STOCK,
            self::VALUE_PAYMENT_NOT_RECEIVED,
            self::VALUE_INVALID_TRANSACTION,
            self::VALUE_ORDER_CANCELED,
            self::VALUE_DUPLICATE_ORDER,
            self::VALUE_TEST_TRANSACTION,
            self::VALUE_ATTRIBUTED_TO_OTHER_CHANNEL,
            self::VALUE_VIOLATES_CAMPAIGN_TERMS,
            self::VALUE_INVALID_CUSTOMER_DETAILS,
            self::VALUE_CUSTOMER_UNREACHABLE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
