<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named createConversionTransaction
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $transactionType
     * @param string $affiliateSiteID
     * @param \StructType\CreateConversionTransactionOptions $options
     * @return nonNegativeInteger|bool
     */
    public function createConversionTransaction($transactionType, $affiliateSiteID, \StructType\CreateConversionTransactionOptions $options)
    {
        try {
            $this->setResult($this->getSoapClient()->createConversionTransaction($transactionType, $affiliateSiteID, $options));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return nonNegativeInteger
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
