<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MaterialItem StructType
 * @subpackage Structs
 */
class MaterialItem extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $ID;
    /**
     * The campaign
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var \StructType\Campaign
     */
    public $campaign;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $name;
    /**
     * The creationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $creationDate;
    /**
     * The modificationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $modificationDate;
    /**
     * The materialBannerDimension
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var \StructType\MaterialBannerDimension
     */
    public $materialBannerDimension;
    /**
     * The referenceSupported
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var bool
     */
    public $referenceSupported;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The conditions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $conditions;
    /**
     * The validFromDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $validFromDate;
    /**
     * The validToDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $validToDate;
    /**
     * The discountFixed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var float
     */
    public $discountFixed;
    /**
     * The discountVariable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var float
     */
    public $discountVariable;
    /**
     * The voucherCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $voucherCode;
    /**
     * The code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $code;
    /**
     * Constructor method for MaterialItem
     * @uses MaterialItem::setID()
     * @uses MaterialItem::setCampaign()
     * @uses MaterialItem::setName()
     * @uses MaterialItem::setCreationDate()
     * @uses MaterialItem::setModificationDate()
     * @uses MaterialItem::setMaterialBannerDimension()
     * @uses MaterialItem::setReferenceSupported()
     * @uses MaterialItem::setDescription()
     * @uses MaterialItem::setConditions()
     * @uses MaterialItem::setValidFromDate()
     * @uses MaterialItem::setValidToDate()
     * @uses MaterialItem::setDiscountFixed()
     * @uses MaterialItem::setDiscountVariable()
     * @uses MaterialItem::setVoucherCode()
     * @uses MaterialItem::setCode()
     * @param int $iD
     * @param \StructType\Campaign $campaign
     * @param string $name
     * @param string $creationDate
     * @param string $modificationDate
     * @param \StructType\MaterialBannerDimension $materialBannerDimension
     * @param bool $referenceSupported
     * @param string $description
     * @param string $conditions
     * @param string $validFromDate
     * @param string $validToDate
     * @param float $discountFixed
     * @param float $discountVariable
     * @param string $voucherCode
     * @param string $code
     */
    public function __construct($iD = null, \StructType\Campaign $campaign = null, $name = null, $creationDate = null, $modificationDate = null, \StructType\MaterialBannerDimension $materialBannerDimension = null, $referenceSupported = null, $description = null, $conditions = null, $validFromDate = null, $validToDate = null, $discountFixed = null, $discountVariable = null, $voucherCode = null, $code = null)
    {
        $this
            ->setID($iD)
            ->setCampaign($campaign)
            ->setName($name)
            ->setCreationDate($creationDate)
            ->setModificationDate($modificationDate)
            ->setMaterialBannerDimension($materialBannerDimension)
            ->setReferenceSupported($referenceSupported)
            ->setDescription($description)
            ->setConditions($conditions)
            ->setValidFromDate($validFromDate)
            ->setValidToDate($validToDate)
            ->setDiscountFixed($discountFixed)
            ->setDiscountVariable($discountVariable)
            ->setVoucherCode($voucherCode)
            ->setCode($code);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\MaterialItem
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get campaign value
     * @return \StructType\Campaign|null
     */
    public function getCampaign()
    {
        return $this->campaign;
    }
    /**
     * Set campaign value
     * @param \StructType\Campaign $campaign
     * @return \StructType\MaterialItem
     */
    public function setCampaign(\StructType\Campaign $campaign = null)
    {
        $this->campaign = $campaign;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\MaterialItem
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get creationDate value
     * @return string|null
     */
    public function getCreationDate()
    {
        return $this->creationDate;
    }
    /**
     * Set creationDate value
     * @param string $creationDate
     * @return \StructType\MaterialItem
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        $this->creationDate = $creationDate;
        return $this;
    }
    /**
     * Get modificationDate value
     * @return string|null
     */
    public function getModificationDate()
    {
        return $this->modificationDate;
    }
    /**
     * Set modificationDate value
     * @param string $modificationDate
     * @return \StructType\MaterialItem
     */
    public function setModificationDate($modificationDate = null)
    {
        // validation for constraint: string
        if (!is_null($modificationDate) && !is_string($modificationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modificationDate, true), gettype($modificationDate)), __LINE__);
        }
        $this->modificationDate = $modificationDate;
        return $this;
    }
    /**
     * Get materialBannerDimension value
     * @return \StructType\MaterialBannerDimension|null
     */
    public function getMaterialBannerDimension()
    {
        return $this->materialBannerDimension;
    }
    /**
     * Set materialBannerDimension value
     * @param \StructType\MaterialBannerDimension $materialBannerDimension
     * @return \StructType\MaterialItem
     */
    public function setMaterialBannerDimension(\StructType\MaterialBannerDimension $materialBannerDimension = null)
    {
        $this->materialBannerDimension = $materialBannerDimension;
        return $this;
    }
    /**
     * Get referenceSupported value
     * @return bool|null
     */
    public function getReferenceSupported()
    {
        return $this->referenceSupported;
    }
    /**
     * Set referenceSupported value
     * @param bool $referenceSupported
     * @return \StructType\MaterialItem
     */
    public function setReferenceSupported($referenceSupported = null)
    {
        // validation for constraint: boolean
        if (!is_null($referenceSupported) && !is_bool($referenceSupported)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($referenceSupported, true), gettype($referenceSupported)), __LINE__);
        }
        $this->referenceSupported = $referenceSupported;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\MaterialItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get conditions value
     * @return string|null
     */
    public function getConditions()
    {
        return $this->conditions;
    }
    /**
     * Set conditions value
     * @param string $conditions
     * @return \StructType\MaterialItem
     */
    public function setConditions($conditions = null)
    {
        // validation for constraint: string
        if (!is_null($conditions) && !is_string($conditions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conditions, true), gettype($conditions)), __LINE__);
        }
        $this->conditions = $conditions;
        return $this;
    }
    /**
     * Get validFromDate value
     * @return string|null
     */
    public function getValidFromDate()
    {
        return $this->validFromDate;
    }
    /**
     * Set validFromDate value
     * @param string $validFromDate
     * @return \StructType\MaterialItem
     */
    public function setValidFromDate($validFromDate = null)
    {
        // validation for constraint: string
        if (!is_null($validFromDate) && !is_string($validFromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validFromDate, true), gettype($validFromDate)), __LINE__);
        }
        $this->validFromDate = $validFromDate;
        return $this;
    }
    /**
     * Get validToDate value
     * @return string|null
     */
    public function getValidToDate()
    {
        return $this->validToDate;
    }
    /**
     * Set validToDate value
     * @param string $validToDate
     * @return \StructType\MaterialItem
     */
    public function setValidToDate($validToDate = null)
    {
        // validation for constraint: string
        if (!is_null($validToDate) && !is_string($validToDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validToDate, true), gettype($validToDate)), __LINE__);
        }
        $this->validToDate = $validToDate;
        return $this;
    }
    /**
     * Get discountFixed value
     * @return float|null
     */
    public function getDiscountFixed()
    {
        return $this->discountFixed;
    }
    /**
     * Set discountFixed value
     * @param float $discountFixed
     * @return \StructType\MaterialItem
     */
    public function setDiscountFixed($discountFixed = null)
    {
        // validation for constraint: float
        if (!is_null($discountFixed) && !(is_float($discountFixed) || is_numeric($discountFixed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountFixed, true), gettype($discountFixed)), __LINE__);
        }
        $this->discountFixed = $discountFixed;
        return $this;
    }
    /**
     * Get discountVariable value
     * @return float|null
     */
    public function getDiscountVariable()
    {
        return $this->discountVariable;
    }
    /**
     * Set discountVariable value
     * @param float $discountVariable
     * @return \StructType\MaterialItem
     */
    public function setDiscountVariable($discountVariable = null)
    {
        // validation for constraint: float
        if (!is_null($discountVariable) && !(is_float($discountVariable) || is_numeric($discountVariable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountVariable, true), gettype($discountVariable)), __LINE__);
        }
        $this->discountVariable = $discountVariable;
        return $this;
    }
    /**
     * Get voucherCode value
     * @return string|null
     */
    public function getVoucherCode()
    {
        return $this->voucherCode;
    }
    /**
     * Set voucherCode value
     * @param string $voucherCode
     * @return \StructType\MaterialItem
     */
    public function setVoucherCode($voucherCode = null)
    {
        // validation for constraint: string
        if (!is_null($voucherCode) && !is_string($voucherCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherCode, true), gettype($voucherCode)), __LINE__);
        }
        $this->voucherCode = $voucherCode;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\MaterialItem
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MaterialItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
