<?php

namespace EnumType;

/**
 * This class stands for Locale EnumType
 * @subpackage Enumerations
 */
class Locale
{
    /**
     * Constant for value 'es_AR'
     * @return string 'es_AR'
     */
    const VALUE_ES_AR = 'es_AR';
    /**
     * Constant for value 'nl_BE'
     * @return string 'nl_BE'
     */
    const VALUE_NL_BE = 'nl_BE';
    /**
     * Constant for value 'fr_BE'
     * @return string 'fr_BE'
     */
    const VALUE_FR_BE = 'fr_BE';
    /**
     * Constant for value 'cs_CZ'
     * @return string 'cs_CZ'
     */
    const VALUE_CS_CZ = 'cs_CZ';
    /**
     * Constant for value 'da_DK'
     * @return string 'da_DK'
     */
    const VALUE_DA_DK = 'da_DK';
    /**
     * Constant for value 'de_DE'
     * @return string 'de_DE'
     */
    const VALUE_DE_DE = 'de_DE';
    /**
     * Constant for value 'et_EE'
     * @return string 'et_EE'
     */
    const VALUE_ET_EE = 'et_EE';
    /**
     * Constant for value 'en_GB'
     * @return string 'en_GB'
     */
    const VALUE_EN_GB = 'en_GB';
    /**
     * Constant for value 'es_ES'
     * @return string 'es_ES'
     */
    const VALUE_ES_ES = 'es_ES';
    /**
     * Constant for value 'fr_FR'
     * @return string 'fr_FR'
     */
    const VALUE_FR_FR = 'fr_FR';
    /**
     * Constant for value 'it_IT'
     * @return string 'it_IT'
     */
    const VALUE_IT_IT = 'it_IT';
    /**
     * Constant for value 'hu_HU'
     * @return string 'hu_HU'
     */
    const VALUE_HU_HU = 'hu_HU';
    /**
     * Constant for value 'nl_NL'
     * @return string 'nl_NL'
     */
    const VALUE_NL_NL = 'nl_NL';
    /**
     * Constant for value 'nb_NO'
     * @return string 'nb_NO'
     */
    const VALUE_NB_NO = 'nb_NO';
    /**
     * Constant for value 'de_AT'
     * @return string 'de_AT'
     */
    const VALUE_DE_AT = 'de_AT';
    /**
     * Constant for value 'pl_PL'
     * @return string 'pl_PL'
     */
    const VALUE_PL_PL = 'pl_PL';
    /**
     * Constant for value 'pt_PT'
     * @return string 'pt_PT'
     */
    const VALUE_PT_PT = 'pt_PT';
    /**
     * Constant for value 'fi_FI'
     * @return string 'fi_FI'
     */
    const VALUE_FI_FI = 'fi_FI';
    /**
     * Constant for value 'sv_SE'
     * @return string 'sv_SE'
     */
    const VALUE_SV_SE = 'sv_SE';
    /**
     * Constant for value 'ru_RU'
     * @return string 'ru_RU'
     */
    const VALUE_RU_RU = 'ru_RU';
    /**
     * Constant for value 'uk_UA'
     * @return string 'uk_UA'
     */
    const VALUE_UK_UA = 'uk_UA';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ES_AR
     * @uses self::VALUE_NL_BE
     * @uses self::VALUE_FR_BE
     * @uses self::VALUE_CS_CZ
     * @uses self::VALUE_DA_DK
     * @uses self::VALUE_DE_DE
     * @uses self::VALUE_ET_EE
     * @uses self::VALUE_EN_GB
     * @uses self::VALUE_ES_ES
     * @uses self::VALUE_FR_FR
     * @uses self::VALUE_IT_IT
     * @uses self::VALUE_HU_HU
     * @uses self::VALUE_NL_NL
     * @uses self::VALUE_NB_NO
     * @uses self::VALUE_DE_AT
     * @uses self::VALUE_PL_PL
     * @uses self::VALUE_PT_PT
     * @uses self::VALUE_FI_FI
     * @uses self::VALUE_SV_SE
     * @uses self::VALUE_RU_RU
     * @uses self::VALUE_UK_UA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ES_AR,
            self::VALUE_NL_BE,
            self::VALUE_FR_BE,
            self::VALUE_CS_CZ,
            self::VALUE_DA_DK,
            self::VALUE_DE_DE,
            self::VALUE_ET_EE,
            self::VALUE_EN_GB,
            self::VALUE_ES_ES,
            self::VALUE_FR_FR,
            self::VALUE_IT_IT,
            self::VALUE_HU_HU,
            self::VALUE_NL_NL,
            self::VALUE_NB_NO,
            self::VALUE_DE_AT,
            self::VALUE_PL_PL,
            self::VALUE_PT_PT,
            self::VALUE_FI_FI,
            self::VALUE_SV_SE,
            self::VALUE_RU_RU,
            self::VALUE_UK_UA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
