<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FeedProductFilter StructType
 * @subpackage Structs
 */
class FeedProductFilter extends AbstractStructBase
{
    /**
     * The feedID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $feedID;
    /**
     * The feedCategoryName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $feedCategoryName;
    /**
     * The campaignID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $campaignID;
    /**
     * The campaignCategoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $campaignCategoryID;
    /**
     * The query
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $query;
    /**
     * The priceFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var float
     */
    public $priceFrom;
    /**
     * The priceTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var float
     */
    public $priceTo;
    /**
     * The limit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $limit;
    /**
     * The offset
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $offset;
    /**
     * Constructor method for FeedProductFilter
     * @uses FeedProductFilter::setFeedID()
     * @uses FeedProductFilter::setFeedCategoryName()
     * @uses FeedProductFilter::setCampaignID()
     * @uses FeedProductFilter::setCampaignCategoryID()
     * @uses FeedProductFilter::setQuery()
     * @uses FeedProductFilter::setPriceFrom()
     * @uses FeedProductFilter::setPriceTo()
     * @uses FeedProductFilter::setLimit()
     * @uses FeedProductFilter::setOffset()
     * @param int $feedID
     * @param string $feedCategoryName
     * @param int $campaignID
     * @param int $campaignCategoryID
     * @param string $query
     * @param float $priceFrom
     * @param float $priceTo
     * @param int $limit
     * @param int $offset
     */
    public function __construct($feedID = null, $feedCategoryName = null, $campaignID = null, $campaignCategoryID = null, $query = null, $priceFrom = null, $priceTo = null, $limit = null, $offset = null)
    {
        $this
            ->setFeedID($feedID)
            ->setFeedCategoryName($feedCategoryName)
            ->setCampaignID($campaignID)
            ->setCampaignCategoryID($campaignCategoryID)
            ->setQuery($query)
            ->setPriceFrom($priceFrom)
            ->setPriceTo($priceTo)
            ->setLimit($limit)
            ->setOffset($offset);
    }
    /**
     * Get feedID value
     * @return int|null
     */
    public function getFeedID()
    {
        return $this->feedID;
    }
    /**
     * Set feedID value
     * @param int $feedID
     * @return \StructType\FeedProductFilter
     */
    public function setFeedID($feedID = null)
    {
        // validation for constraint: int
        if (!is_null($feedID) && !(is_int($feedID) || ctype_digit($feedID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($feedID, true), gettype($feedID)), __LINE__);
        }
        $this->feedID = $feedID;
        return $this;
    }
    /**
     * Get feedCategoryName value
     * @return string|null
     */
    public function getFeedCategoryName()
    {
        return $this->feedCategoryName;
    }
    /**
     * Set feedCategoryName value
     * @param string $feedCategoryName
     * @return \StructType\FeedProductFilter
     */
    public function setFeedCategoryName($feedCategoryName = null)
    {
        // validation for constraint: string
        if (!is_null($feedCategoryName) && !is_string($feedCategoryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feedCategoryName, true), gettype($feedCategoryName)), __LINE__);
        }
        $this->feedCategoryName = $feedCategoryName;
        return $this;
    }
    /**
     * Get campaignID value
     * @return int|null
     */
    public function getCampaignID()
    {
        return $this->campaignID;
    }
    /**
     * Set campaignID value
     * @param int $campaignID
     * @return \StructType\FeedProductFilter
     */
    public function setCampaignID($campaignID = null)
    {
        // validation for constraint: int
        if (!is_null($campaignID) && !(is_int($campaignID) || ctype_digit($campaignID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($campaignID, true), gettype($campaignID)), __LINE__);
        }
        $this->campaignID = $campaignID;
        return $this;
    }
    /**
     * Get campaignCategoryID value
     * @return int|null
     */
    public function getCampaignCategoryID()
    {
        return $this->campaignCategoryID;
    }
    /**
     * Set campaignCategoryID value
     * @param int $campaignCategoryID
     * @return \StructType\FeedProductFilter
     */
    public function setCampaignCategoryID($campaignCategoryID = null)
    {
        // validation for constraint: int
        if (!is_null($campaignCategoryID) && !(is_int($campaignCategoryID) || ctype_digit($campaignCategoryID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($campaignCategoryID, true), gettype($campaignCategoryID)), __LINE__);
        }
        $this->campaignCategoryID = $campaignCategoryID;
        return $this;
    }
    /**
     * Get query value
     * @return string|null
     */
    public function getQuery()
    {
        return $this->query;
    }
    /**
     * Set query value
     * @param string $query
     * @return \StructType\FeedProductFilter
     */
    public function setQuery($query = null)
    {
        // validation for constraint: string
        if (!is_null($query) && !is_string($query)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($query, true), gettype($query)), __LINE__);
        }
        $this->query = $query;
        return $this;
    }
    /**
     * Get priceFrom value
     * @return float|null
     */
    public function getPriceFrom()
    {
        return $this->priceFrom;
    }
    /**
     * Set priceFrom value
     * @param float $priceFrom
     * @return \StructType\FeedProductFilter
     */
    public function setPriceFrom($priceFrom = null)
    {
        // validation for constraint: float
        if (!is_null($priceFrom) && !(is_float($priceFrom) || is_numeric($priceFrom))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($priceFrom, true), gettype($priceFrom)), __LINE__);
        }
        $this->priceFrom = $priceFrom;
        return $this;
    }
    /**
     * Get priceTo value
     * @return float|null
     */
    public function getPriceTo()
    {
        return $this->priceTo;
    }
    /**
     * Set priceTo value
     * @param float $priceTo
     * @return \StructType\FeedProductFilter
     */
    public function setPriceTo($priceTo = null)
    {
        // validation for constraint: float
        if (!is_null($priceTo) && !(is_float($priceTo) || is_numeric($priceTo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($priceTo, true), gettype($priceTo)), __LINE__);
        }
        $this->priceTo = $priceTo;
        return $this;
    }
    /**
     * Get limit value
     * @return int|null
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param int $limit
     * @return \StructType\FeedProductFilter
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !(is_int($limit) || ctype_digit($limit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($limit, true), gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Get offset value
     * @return int|null
     */
    public function getOffset()
    {
        return $this->offset;
    }
    /**
     * Set offset value
     * @param int $offset
     * @return \StructType\FeedProductFilter
     */
    public function setOffset($offset = null)
    {
        // validation for constraint: int
        if (!is_null($offset) && !(is_int($offset) || ctype_digit($offset))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($offset, true), gettype($offset)), __LINE__);
        }
        $this->offset = $offset;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FeedProductFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
