<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment StructType
 * @subpackage Structs
 */
class Payment extends AbstractStructBase
{
    /**
     * The invoiceNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $invoiceNumber;
    /**
     * The currency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $currency;
    /**
     * The subTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var float
     */
    public $subTotal;
    /**
     * The VAT
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var float
     */
    public $VAT;
    /**
     * The endTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var float
     */
    public $endTotal;
    /**
     * The billDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $billDate;
    /**
     * The payDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $payDate;
    /**
     * Constructor method for Payment
     * @uses Payment::setInvoiceNumber()
     * @uses Payment::setCurrency()
     * @uses Payment::setSubTotal()
     * @uses Payment::setVAT()
     * @uses Payment::setEndTotal()
     * @uses Payment::setBillDate()
     * @uses Payment::setPayDate()
     * @param string $invoiceNumber
     * @param string $currency
     * @param float $subTotal
     * @param float $vAT
     * @param float $endTotal
     * @param string $billDate
     * @param string $payDate
     */
    public function __construct($invoiceNumber = null, $currency = null, $subTotal = null, $vAT = null, $endTotal = null, $billDate = null, $payDate = null)
    {
        $this
            ->setInvoiceNumber($invoiceNumber)
            ->setCurrency($currency)
            ->setSubTotal($subTotal)
            ->setVAT($vAT)
            ->setEndTotal($endTotal)
            ->setBillDate($billDate)
            ->setPayDate($payDate);
    }
    /**
     * Get invoiceNumber value
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->invoiceNumber;
    }
    /**
     * Set invoiceNumber value
     * @param string $invoiceNumber
     * @return \StructType\Payment
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        $this->invoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\Payment
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get subTotal value
     * @return float|null
     */
    public function getSubTotal()
    {
        return $this->subTotal;
    }
    /**
     * Set subTotal value
     * @param float $subTotal
     * @return \StructType\Payment
     */
    public function setSubTotal($subTotal = null)
    {
        // validation for constraint: float
        if (!is_null($subTotal) && !(is_float($subTotal) || is_numeric($subTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($subTotal, true), gettype($subTotal)), __LINE__);
        }
        $this->subTotal = $subTotal;
        return $this;
    }
    /**
     * Get VAT value
     * @return float|null
     */
    public function getVAT()
    {
        return $this->VAT;
    }
    /**
     * Set VAT value
     * @param float $vAT
     * @return \StructType\Payment
     */
    public function setVAT($vAT = null)
    {
        // validation for constraint: float
        if (!is_null($vAT) && !(is_float($vAT) || is_numeric($vAT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vAT, true), gettype($vAT)), __LINE__);
        }
        $this->VAT = $vAT;
        return $this;
    }
    /**
     * Get endTotal value
     * @return float|null
     */
    public function getEndTotal()
    {
        return $this->endTotal;
    }
    /**
     * Set endTotal value
     * @param float $endTotal
     * @return \StructType\Payment
     */
    public function setEndTotal($endTotal = null)
    {
        // validation for constraint: float
        if (!is_null($endTotal) && !(is_float($endTotal) || is_numeric($endTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($endTotal, true), gettype($endTotal)), __LINE__);
        }
        $this->endTotal = $endTotal;
        return $this;
    }
    /**
     * Get billDate value
     * @return string|null
     */
    public function getBillDate()
    {
        return $this->billDate;
    }
    /**
     * Set billDate value
     * @param string $billDate
     * @return \StructType\Payment
     */
    public function setBillDate($billDate = null)
    {
        // validation for constraint: string
        if (!is_null($billDate) && !is_string($billDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billDate, true), gettype($billDate)), __LINE__);
        }
        $this->billDate = $billDate;
        return $this;
    }
    /**
     * Get payDate value
     * @return string|null
     */
    public function getPayDate()
    {
        return $this->payDate;
    }
    /**
     * Set payDate value
     * @param string $payDate
     * @return \StructType\Payment
     */
    public function setPayDate($payDate = null)
    {
        // validation for constraint: string
        if (!is_null($payDate) && !is_string($payDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payDate, true), gettype($payDate)), __LINE__);
        }
        $this->payDate = $payDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Payment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
