<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Feed StructType
 * @subpackage Structs
 */
class Feed extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $ID;
    /**
     * The campaign
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var \StructType\Campaign
     */
    public $campaign;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $name;
    /**
     * The URL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $URL;
    /**
     * The updateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $updateDate;
    /**
     * The updateInterval
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $updateInterval;
    /**
     * The productCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $productCount;
    /**
     * The assignmentStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $assignmentStatus;
    /**
     * Constructor method for Feed
     * @uses Feed::setID()
     * @uses Feed::setCampaign()
     * @uses Feed::setName()
     * @uses Feed::setURL()
     * @uses Feed::setUpdateDate()
     * @uses Feed::setUpdateInterval()
     * @uses Feed::setProductCount()
     * @uses Feed::setAssignmentStatus()
     * @param int $iD
     * @param \StructType\Campaign $campaign
     * @param string $name
     * @param string $uRL
     * @param string $updateDate
     * @param string $updateInterval
     * @param int $productCount
     * @param string $assignmentStatus
     */
    public function __construct($iD = null, \StructType\Campaign $campaign = null, $name = null, $uRL = null, $updateDate = null, $updateInterval = null, $productCount = null, $assignmentStatus = null)
    {
        $this
            ->setID($iD)
            ->setCampaign($campaign)
            ->setName($name)
            ->setURL($uRL)
            ->setUpdateDate($updateDate)
            ->setUpdateInterval($updateInterval)
            ->setProductCount($productCount)
            ->setAssignmentStatus($assignmentStatus);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\Feed
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get campaign value
     * @return \StructType\Campaign|null
     */
    public function getCampaign()
    {
        return $this->campaign;
    }
    /**
     * Set campaign value
     * @param \StructType\Campaign $campaign
     * @return \StructType\Feed
     */
    public function setCampaign(\StructType\Campaign $campaign = null)
    {
        $this->campaign = $campaign;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Feed
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \StructType\Feed
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRL, true), gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Get updateDate value
     * @return string|null
     */
    public function getUpdateDate()
    {
        return $this->updateDate;
    }
    /**
     * Set updateDate value
     * @param string $updateDate
     * @return \StructType\Feed
     */
    public function setUpdateDate($updateDate = null)
    {
        // validation for constraint: string
        if (!is_null($updateDate) && !is_string($updateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updateDate, true), gettype($updateDate)), __LINE__);
        }
        $this->updateDate = $updateDate;
        return $this;
    }
    /**
     * Get updateInterval value
     * @return string|null
     */
    public function getUpdateInterval()
    {
        return $this->updateInterval;
    }
    /**
     * Set updateInterval value
     * @param string $updateInterval
     * @return \StructType\Feed
     */
    public function setUpdateInterval($updateInterval = null)
    {
        // validation for constraint: string
        if (!is_null($updateInterval) && !is_string($updateInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updateInterval, true), gettype($updateInterval)), __LINE__);
        }
        $this->updateInterval = $updateInterval;
        return $this;
    }
    /**
     * Get productCount value
     * @return int|null
     */
    public function getProductCount()
    {
        return $this->productCount;
    }
    /**
     * Set productCount value
     * @param int $productCount
     * @return \StructType\Feed
     */
    public function setProductCount($productCount = null)
    {
        // validation for constraint: int
        if (!is_null($productCount) && !(is_int($productCount) || ctype_digit($productCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productCount, true), gettype($productCount)), __LINE__);
        }
        $this->productCount = $productCount;
        return $this;
    }
    /**
     * Get assignmentStatus value
     * @return string|null
     */
    public function getAssignmentStatus()
    {
        return $this->assignmentStatus;
    }
    /**
     * Set assignmentStatus value
     * @uses \EnumType\CampaignAssignmentStatus::valueIsValid()
     * @uses \EnumType\CampaignAssignmentStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $assignmentStatus
     * @return \StructType\Feed
     */
    public function setAssignmentStatus($assignmentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CampaignAssignmentStatus::valueIsValid($assignmentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CampaignAssignmentStatus', is_array($assignmentStatus) ? implode(', ', $assignmentStatus) : var_export($assignmentStatus, true), implode(', ', \EnumType\CampaignAssignmentStatus::getValidValues())), __LINE__);
        }
        $this->assignmentStatus = $assignmentStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Feed
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
