<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConversionTransactionFilter StructType
 * @subpackage Structs
 */
class ConversionTransactionFilter extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ID;
    /**
     * The transactionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $transactionType;
    /**
     * The transactionStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $transactionStatus;
    /**
     * The registrationDateFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $registrationDateFrom;
    /**
     * The registrationDateTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $registrationDateTo;
    /**
     * The assessmentDateFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $assessmentDateFrom;
    /**
     * The assessmentDateTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $assessmentDateTo;
    /**
     * The reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $reference;
    /**
     * The limit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $limit;
    /**
     * The offset
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $offset;
    /**
     * The sort
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $sort;
    /**
     * The sortDirection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $sortDirection;
    /**
     * Constructor method for ConversionTransactionFilter
     * @uses ConversionTransactionFilter::setID()
     * @uses ConversionTransactionFilter::setTransactionType()
     * @uses ConversionTransactionFilter::setTransactionStatus()
     * @uses ConversionTransactionFilter::setRegistrationDateFrom()
     * @uses ConversionTransactionFilter::setRegistrationDateTo()
     * @uses ConversionTransactionFilter::setAssessmentDateFrom()
     * @uses ConversionTransactionFilter::setAssessmentDateTo()
     * @uses ConversionTransactionFilter::setReference()
     * @uses ConversionTransactionFilter::setLimit()
     * @uses ConversionTransactionFilter::setOffset()
     * @uses ConversionTransactionFilter::setSort()
     * @uses ConversionTransactionFilter::setSortDirection()
     * @param int $iD
     * @param string $transactionType
     * @param string $transactionStatus
     * @param string $registrationDateFrom
     * @param string $registrationDateTo
     * @param string $assessmentDateFrom
     * @param string $assessmentDateTo
     * @param string $reference
     * @param int $limit
     * @param int $offset
     * @param string $sort
     * @param string $sortDirection
     */
    public function __construct($iD = null, $transactionType = null, $transactionStatus = null, $registrationDateFrom = null, $registrationDateTo = null, $assessmentDateFrom = null, $assessmentDateTo = null, $reference = null, $limit = null, $offset = null, $sort = null, $sortDirection = null)
    {
        $this
            ->setID($iD)
            ->setTransactionType($transactionType)
            ->setTransactionStatus($transactionStatus)
            ->setRegistrationDateFrom($registrationDateFrom)
            ->setRegistrationDateTo($registrationDateTo)
            ->setAssessmentDateFrom($assessmentDateFrom)
            ->setAssessmentDateTo($assessmentDateTo)
            ->setReference($reference)
            ->setLimit($limit)
            ->setOffset($offset)
            ->setSort($sort)
            ->setSortDirection($sortDirection);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\ConversionTransactionFilter
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get transactionType value
     * @return string|null
     */
    public function getTransactionType()
    {
        return $this->transactionType;
    }
    /**
     * Set transactionType value
     * @uses \EnumType\TransactionType::valueIsValid()
     * @uses \EnumType\TransactionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionType
     * @return \StructType\ConversionTransactionFilter
     */
    public function setTransactionType($transactionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransactionType::valueIsValid($transactionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransactionType', is_array($transactionType) ? implode(', ', $transactionType) : var_export($transactionType, true), implode(', ', \EnumType\TransactionType::getValidValues())), __LINE__);
        }
        $this->transactionType = $transactionType;
        return $this;
    }
    /**
     * Get transactionStatus value
     * @return string|null
     */
    public function getTransactionStatus()
    {
        return $this->transactionStatus;
    }
    /**
     * Set transactionStatus value
     * @uses \EnumType\TransactionStatus::valueIsValid()
     * @uses \EnumType\TransactionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionStatus
     * @return \StructType\ConversionTransactionFilter
     */
    public function setTransactionStatus($transactionStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransactionStatus::valueIsValid($transactionStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransactionStatus', is_array($transactionStatus) ? implode(', ', $transactionStatus) : var_export($transactionStatus, true), implode(', ', \EnumType\TransactionStatus::getValidValues())), __LINE__);
        }
        $this->transactionStatus = $transactionStatus;
        return $this;
    }
    /**
     * Get registrationDateFrom value
     * @return string|null
     */
    public function getRegistrationDateFrom()
    {
        return $this->registrationDateFrom;
    }
    /**
     * Set registrationDateFrom value
     * @param string $registrationDateFrom
     * @return \StructType\ConversionTransactionFilter
     */
    public function setRegistrationDateFrom($registrationDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($registrationDateFrom) && !is_string($registrationDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registrationDateFrom, true), gettype($registrationDateFrom)), __LINE__);
        }
        $this->registrationDateFrom = $registrationDateFrom;
        return $this;
    }
    /**
     * Get registrationDateTo value
     * @return string|null
     */
    public function getRegistrationDateTo()
    {
        return $this->registrationDateTo;
    }
    /**
     * Set registrationDateTo value
     * @param string $registrationDateTo
     * @return \StructType\ConversionTransactionFilter
     */
    public function setRegistrationDateTo($registrationDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($registrationDateTo) && !is_string($registrationDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registrationDateTo, true), gettype($registrationDateTo)), __LINE__);
        }
        $this->registrationDateTo = $registrationDateTo;
        return $this;
    }
    /**
     * Get assessmentDateFrom value
     * @return string|null
     */
    public function getAssessmentDateFrom()
    {
        return $this->assessmentDateFrom;
    }
    /**
     * Set assessmentDateFrom value
     * @param string $assessmentDateFrom
     * @return \StructType\ConversionTransactionFilter
     */
    public function setAssessmentDateFrom($assessmentDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($assessmentDateFrom) && !is_string($assessmentDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assessmentDateFrom, true), gettype($assessmentDateFrom)), __LINE__);
        }
        $this->assessmentDateFrom = $assessmentDateFrom;
        return $this;
    }
    /**
     * Get assessmentDateTo value
     * @return string|null
     */
    public function getAssessmentDateTo()
    {
        return $this->assessmentDateTo;
    }
    /**
     * Set assessmentDateTo value
     * @param string $assessmentDateTo
     * @return \StructType\ConversionTransactionFilter
     */
    public function setAssessmentDateTo($assessmentDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($assessmentDateTo) && !is_string($assessmentDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assessmentDateTo, true), gettype($assessmentDateTo)), __LINE__);
        }
        $this->assessmentDateTo = $assessmentDateTo;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \StructType\ConversionTransactionFilter
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get limit value
     * @return int|null
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param int $limit
     * @return \StructType\ConversionTransactionFilter
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !(is_int($limit) || ctype_digit($limit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($limit, true), gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Get offset value
     * @return int|null
     */
    public function getOffset()
    {
        return $this->offset;
    }
    /**
     * Set offset value
     * @param int $offset
     * @return \StructType\ConversionTransactionFilter
     */
    public function setOffset($offset = null)
    {
        // validation for constraint: int
        if (!is_null($offset) && !(is_int($offset) || ctype_digit($offset))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($offset, true), gettype($offset)), __LINE__);
        }
        $this->offset = $offset;
        return $this;
    }
    /**
     * Get sort value
     * @return string|null
     */
    public function getSort()
    {
        return $this->sort;
    }
    /**
     * Set sort value
     * @uses \EnumType\TransactionConversionSort::valueIsValid()
     * @uses \EnumType\TransactionConversionSort::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sort
     * @return \StructType\ConversionTransactionFilter
     */
    public function setSort($sort = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransactionConversionSort::valueIsValid($sort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransactionConversionSort', is_array($sort) ? implode(', ', $sort) : var_export($sort, true), implode(', ', \EnumType\TransactionConversionSort::getValidValues())), __LINE__);
        }
        $this->sort = $sort;
        return $this;
    }
    /**
     * Get sortDirection value
     * @return string|null
     */
    public function getSortDirection()
    {
        return $this->sortDirection;
    }
    /**
     * Set sortDirection value
     * @uses \EnumType\SortDirection::valueIsValid()
     * @uses \EnumType\SortDirection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sortDirection
     * @return \StructType\ConversionTransactionFilter
     */
    public function setSortDirection($sortDirection = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SortDirection::valueIsValid($sortDirection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SortDirection', is_array($sortDirection) ? implode(', ', $sortDirection) : var_export($sortDirection, true), implode(', ', \EnumType\SortDirection::getValidValues())), __LINE__);
        }
        $this->sortDirection = $sortDirection;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConversionTransactionFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
