<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CampaignCommissionExtended StructType
 * @subpackage Structs
 */
class CampaignCommissionExtended extends AbstractStructBase
{
    /**
     * The impressionCommission
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var float
     */
    public $impressionCommission;
    /**
     * The clickCommission
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var float
     */
    public $clickCommission;
    /**
     * The fixedCommission
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var float
     */
    public $fixedCommission;
    /**
     * The products
     * Meta informations extracted from the WSDL
     * - arrayType: tns:CampaignCommissionProduct[]
     * - base: SOAP-ENC:Array
     * - maxOccurs: 1
     * - ref: SOAP-ENC:arrayType
     * @var \StructType\CampaignCommissionProduct[]
     */
    public $products;
    /**
     * Constructor method for CampaignCommissionExtended
     * @uses CampaignCommissionExtended::setImpressionCommission()
     * @uses CampaignCommissionExtended::setClickCommission()
     * @uses CampaignCommissionExtended::setFixedCommission()
     * @uses CampaignCommissionExtended::setProducts()
     * @param float $impressionCommission
     * @param float $clickCommission
     * @param float $fixedCommission
     * @param \StructType\CampaignCommissionProduct[] $products
     */
    public function __construct($impressionCommission = null, $clickCommission = null, $fixedCommission = null, array $products = array())
    {
        $this
            ->setImpressionCommission($impressionCommission)
            ->setClickCommission($clickCommission)
            ->setFixedCommission($fixedCommission)
            ->setProducts($products);
    }
    /**
     * Get impressionCommission value
     * @return float|null
     */
    public function getImpressionCommission()
    {
        return $this->impressionCommission;
    }
    /**
     * Set impressionCommission value
     * @param float $impressionCommission
     * @return \StructType\CampaignCommissionExtended
     */
    public function setImpressionCommission($impressionCommission = null)
    {
        // validation for constraint: float
        if (!is_null($impressionCommission) && !(is_float($impressionCommission) || is_numeric($impressionCommission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($impressionCommission, true), gettype($impressionCommission)), __LINE__);
        }
        $this->impressionCommission = $impressionCommission;
        return $this;
    }
    /**
     * Get clickCommission value
     * @return float|null
     */
    public function getClickCommission()
    {
        return $this->clickCommission;
    }
    /**
     * Set clickCommission value
     * @param float $clickCommission
     * @return \StructType\CampaignCommissionExtended
     */
    public function setClickCommission($clickCommission = null)
    {
        // validation for constraint: float
        if (!is_null($clickCommission) && !(is_float($clickCommission) || is_numeric($clickCommission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($clickCommission, true), gettype($clickCommission)), __LINE__);
        }
        $this->clickCommission = $clickCommission;
        return $this;
    }
    /**
     * Get fixedCommission value
     * @return float|null
     */
    public function getFixedCommission()
    {
        return $this->fixedCommission;
    }
    /**
     * Set fixedCommission value
     * @param float $fixedCommission
     * @return \StructType\CampaignCommissionExtended
     */
    public function setFixedCommission($fixedCommission = null)
    {
        // validation for constraint: float
        if (!is_null($fixedCommission) && !(is_float($fixedCommission) || is_numeric($fixedCommission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fixedCommission, true), gettype($fixedCommission)), __LINE__);
        }
        $this->fixedCommission = $fixedCommission;
        return $this;
    }
    /**
     * Get products value
     * @return \StructType\CampaignCommissionProduct[]|null
     */
    public function getProducts()
    {
        return $this->products;
    }
    /**
     * This method is responsible for validating the values passed to the setProducts method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProducts method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProductsForArrayConstraintsFromSetProducts(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $campaignCommissionExtendedProductsItem) {
            // validation for constraint: itemType
            if (!$campaignCommissionExtendedProductsItem instanceof \StructType\CampaignCommissionProduct) {
                $invalidValues[] = is_object($campaignCommissionExtendedProductsItem) ? get_class($campaignCommissionExtendedProductsItem) : sprintf('%s(%s)', gettype($campaignCommissionExtendedProductsItem), var_export($campaignCommissionExtendedProductsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The products property can only contain items of type \StructType\CampaignCommissionProduct, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set products value
     * @throws \InvalidArgumentException
     * @param \StructType\CampaignCommissionProduct[] $products
     * @return \StructType\CampaignCommissionExtended
     */
    public function setProducts(array $products = array())
    {
        // validation for constraint: array
        if ('' !== ($productsArrayErrorMessage = self::validateProductsForArrayConstraintsFromSetProducts($products))) {
            throw new \InvalidArgumentException($productsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($products) && count($products) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1', count($products)), __LINE__);
        }
        $this->products = $products;
        return $this;
    }
    /**
     * Add item to products value
     * @throws \InvalidArgumentException
     * @param \StructType\CampaignCommissionProduct $item
     * @return \StructType\CampaignCommissionExtended
     */
    public function addToProducts(\StructType\CampaignCommissionProduct $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CampaignCommissionProduct) {
            throw new \InvalidArgumentException(sprintf('The products property can only contain items of type \StructType\CampaignCommissionProduct, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($this->products) && count($this->products) >= 1) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1', count($this->products)), __LINE__);
        }
        $this->products[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CampaignCommissionExtended
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
