<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Attributions StructType
 * @subpackage Structs
 */
class Attributions extends AbstractStructBase
{
    /**
     * The affiliateSites
     * Meta informations extracted from the WSDL
     * - arrayType: tns:AttributedAffiliateSite[]
     * - base: SOAP-ENC:Array
     * - maxOccurs: 1
     * - ref: SOAP-ENC:arrayType
     * @var \StructType\AttributedAffiliateSite[]
     */
    public $affiliateSites;
    /**
     * Constructor method for Attributions
     * @uses Attributions::setAffiliateSites()
     * @param \StructType\AttributedAffiliateSite[] $affiliateSites
     */
    public function __construct(array $affiliateSites = array())
    {
        $this
            ->setAffiliateSites($affiliateSites);
    }
    /**
     * Get affiliateSites value
     * @return \StructType\AttributedAffiliateSite[]|null
     */
    public function getAffiliateSites()
    {
        return $this->affiliateSites;
    }
    /**
     * This method is responsible for validating the values passed to the setAffiliateSites method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAffiliateSites method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAffiliateSitesForArrayConstraintsFromSetAffiliateSites(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $attributionsAffiliateSitesItem) {
            // validation for constraint: itemType
            if (!$attributionsAffiliateSitesItem instanceof \StructType\AttributedAffiliateSite) {
                $invalidValues[] = is_object($attributionsAffiliateSitesItem) ? get_class($attributionsAffiliateSitesItem) : sprintf('%s(%s)', gettype($attributionsAffiliateSitesItem), var_export($attributionsAffiliateSitesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The affiliateSites property can only contain items of type \StructType\AttributedAffiliateSite, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set affiliateSites value
     * @throws \InvalidArgumentException
     * @param \StructType\AttributedAffiliateSite[] $affiliateSites
     * @return \StructType\Attributions
     */
    public function setAffiliateSites(array $affiliateSites = array())
    {
        // validation for constraint: array
        if ('' !== ($affiliateSitesArrayErrorMessage = self::validateAffiliateSitesForArrayConstraintsFromSetAffiliateSites($affiliateSites))) {
            throw new \InvalidArgumentException($affiliateSitesArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($affiliateSites) && count($affiliateSites) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1', count($affiliateSites)), __LINE__);
        }
        $this->affiliateSites = $affiliateSites;
        return $this;
    }
    /**
     * Add item to affiliateSites value
     * @throws \InvalidArgumentException
     * @param \StructType\AttributedAffiliateSite $item
     * @return \StructType\Attributions
     */
    public function addToAffiliateSites(\StructType\AttributedAffiliateSite $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AttributedAffiliateSite) {
            throw new \InvalidArgumentException(sprintf('The affiliateSites property can only contain items of type \StructType\AttributedAffiliateSite, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($this->affiliateSites) && count($this->affiliateSites) >= 1) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1', count($this->affiliateSites)), __LINE__);
        }
        $this->affiliateSites[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Attributions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
