<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AttributedAffiliateSite StructType
 * @subpackage Structs
 */
class AttributedAffiliateSite extends AbstractStructBase
{
    /**
     * The affiliateSiteID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $affiliateSiteID;
    /**
     * The commission
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var float
     */
    public $commission;
    /**
     * The position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $position;
    /**
     * The IP
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $IP;
    /**
     * The transactionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $transactionType;
    /**
     * The transactionStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $transactionStatus;
    /**
     * The reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $reference;
    /**
     * The registrationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $registrationDate;
    /**
     * The paidOut
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var bool
     */
    public $paidOut;
    /**
     * Constructor method for AttributedAffiliateSite
     * @uses AttributedAffiliateSite::setAffiliateSiteID()
     * @uses AttributedAffiliateSite::setCommission()
     * @uses AttributedAffiliateSite::setPosition()
     * @uses AttributedAffiliateSite::setIP()
     * @uses AttributedAffiliateSite::setTransactionType()
     * @uses AttributedAffiliateSite::setTransactionStatus()
     * @uses AttributedAffiliateSite::setReference()
     * @uses AttributedAffiliateSite::setRegistrationDate()
     * @uses AttributedAffiliateSite::setPaidOut()
     * @param int $affiliateSiteID
     * @param float $commission
     * @param string $position
     * @param string $iP
     * @param string $transactionType
     * @param string $transactionStatus
     * @param string $reference
     * @param string $registrationDate
     * @param bool $paidOut
     */
    public function __construct($affiliateSiteID = null, $commission = null, $position = null, $iP = null, $transactionType = null, $transactionStatus = null, $reference = null, $registrationDate = null, $paidOut = null)
    {
        $this
            ->setAffiliateSiteID($affiliateSiteID)
            ->setCommission($commission)
            ->setPosition($position)
            ->setIP($iP)
            ->setTransactionType($transactionType)
            ->setTransactionStatus($transactionStatus)
            ->setReference($reference)
            ->setRegistrationDate($registrationDate)
            ->setPaidOut($paidOut);
    }
    /**
     * Get affiliateSiteID value
     * @return int|null
     */
    public function getAffiliateSiteID()
    {
        return $this->affiliateSiteID;
    }
    /**
     * Set affiliateSiteID value
     * @param int $affiliateSiteID
     * @return \StructType\AttributedAffiliateSite
     */
    public function setAffiliateSiteID($affiliateSiteID = null)
    {
        // validation for constraint: int
        if (!is_null($affiliateSiteID) && !(is_int($affiliateSiteID) || ctype_digit($affiliateSiteID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($affiliateSiteID, true), gettype($affiliateSiteID)), __LINE__);
        }
        $this->affiliateSiteID = $affiliateSiteID;
        return $this;
    }
    /**
     * Get commission value
     * @return float|null
     */
    public function getCommission()
    {
        return $this->commission;
    }
    /**
     * Set commission value
     * @param float $commission
     * @return \StructType\AttributedAffiliateSite
     */
    public function setCommission($commission = null)
    {
        // validation for constraint: float
        if (!is_null($commission) && !(is_float($commission) || is_numeric($commission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($commission, true), gettype($commission)), __LINE__);
        }
        $this->commission = $commission;
        return $this;
    }
    /**
     * Get position value
     * @return string|null
     */
    public function getPosition()
    {
        return $this->position;
    }
    /**
     * Set position value
     * @param string $position
     * @return \StructType\AttributedAffiliateSite
     */
    public function setPosition($position = null)
    {
        // validation for constraint: string
        if (!is_null($position) && !is_string($position)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($position, true), gettype($position)), __LINE__);
        }
        $this->position = $position;
        return $this;
    }
    /**
     * Get IP value
     * @return string|null
     */
    public function getIP()
    {
        return $this->IP;
    }
    /**
     * Set IP value
     * @param string $iP
     * @return \StructType\AttributedAffiliateSite
     */
    public function setIP($iP = null)
    {
        // validation for constraint: string
        if (!is_null($iP) && !is_string($iP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iP, true), gettype($iP)), __LINE__);
        }
        $this->IP = $iP;
        return $this;
    }
    /**
     * Get transactionType value
     * @return string|null
     */
    public function getTransactionType()
    {
        return $this->transactionType;
    }
    /**
     * Set transactionType value
     * @uses \EnumType\TransactionType::valueIsValid()
     * @uses \EnumType\TransactionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionType
     * @return \StructType\AttributedAffiliateSite
     */
    public function setTransactionType($transactionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransactionType::valueIsValid($transactionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransactionType', is_array($transactionType) ? implode(', ', $transactionType) : var_export($transactionType, true), implode(', ', \EnumType\TransactionType::getValidValues())), __LINE__);
        }
        $this->transactionType = $transactionType;
        return $this;
    }
    /**
     * Get transactionStatus value
     * @return string|null
     */
    public function getTransactionStatus()
    {
        return $this->transactionStatus;
    }
    /**
     * Set transactionStatus value
     * @uses \EnumType\TransactionStatus::valueIsValid()
     * @uses \EnumType\TransactionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionStatus
     * @return \StructType\AttributedAffiliateSite
     */
    public function setTransactionStatus($transactionStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransactionStatus::valueIsValid($transactionStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransactionStatus', is_array($transactionStatus) ? implode(', ', $transactionStatus) : var_export($transactionStatus, true), implode(', ', \EnumType\TransactionStatus::getValidValues())), __LINE__);
        }
        $this->transactionStatus = $transactionStatus;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \StructType\AttributedAffiliateSite
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get registrationDate value
     * @return string|null
     */
    public function getRegistrationDate()
    {
        return $this->registrationDate;
    }
    /**
     * Set registrationDate value
     * @param string $registrationDate
     * @return \StructType\AttributedAffiliateSite
     */
    public function setRegistrationDate($registrationDate = null)
    {
        // validation for constraint: string
        if (!is_null($registrationDate) && !is_string($registrationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registrationDate, true), gettype($registrationDate)), __LINE__);
        }
        $this->registrationDate = $registrationDate;
        return $this;
    }
    /**
     * Get paidOut value
     * @return bool|null
     */
    public function getPaidOut()
    {
        return $this->paidOut;
    }
    /**
     * Set paidOut value
     * @param bool $paidOut
     * @return \StructType\AttributedAffiliateSite
     */
    public function setPaidOut($paidOut = null)
    {
        // validation for constraint: boolean
        if (!is_null($paidOut) && !is_bool($paidOut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($paidOut, true), gettype($paidOut)), __LINE__);
        }
        $this->paidOut = $paidOut;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AttributedAffiliateSite
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
