<?php

namespace EnumType;

/**
 * This class stands for MaterialItemSort EnumType
 * @subpackage Enumerations
 */
class MaterialItemSort
{
    /**
     * Constant for value 'ID'
     * @return string 'ID'
     */
    const VALUE_ID = 'ID';
    /**
     * Constant for value 'creationDate'
     * @return string 'creationDate'
     */
    const VALUE_CREATION_DATE = 'creationDate';
    /**
     * Constant for value 'modificationDate'
     * @return string 'modificationDate'
     */
    const VALUE_MODIFICATION_DATE = 'modificationDate';
    /**
     * Constant for value 'campaignName'
     * @return string 'campaignName'
     */
    const VALUE_CAMPAIGN_NAME = 'campaignName';
    /**
     * Constant for value 'elementSize'
     * @return string 'elementSize'
     */
    const VALUE_ELEMENT_SIZE = 'elementSize';
    /**
     * Constant for value 'linkText'
     * @return string 'linkText'
     */
    const VALUE_LINK_TEXT = 'linkText';
    /**
     * Constant for value 'title'
     * @return string 'title'
     */
    const VALUE_TITLE = 'title';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ID
     * @uses self::VALUE_CREATION_DATE
     * @uses self::VALUE_MODIFICATION_DATE
     * @uses self::VALUE_CAMPAIGN_NAME
     * @uses self::VALUE_ELEMENT_SIZE
     * @uses self::VALUE_LINK_TEXT
     * @uses self::VALUE_TITLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ID,
            self::VALUE_CREATION_DATE,
            self::VALUE_MODIFICATION_DATE,
            self::VALUE_CAMPAIGN_NAME,
            self::VALUE_ELEMENT_SIZE,
            self::VALUE_LINK_TEXT,
            self::VALUE_TITLE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
