<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Campaign StructType
 * @subpackage Structs
 */
class Campaign extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $ID;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $name;
    /**
     * The URL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $URL;
    /**
     * The info
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var \StructType\CampaignInfo
     */
    public $info;
    /**
     * Constructor method for Campaign
     * @uses Campaign::setID()
     * @uses Campaign::setName()
     * @uses Campaign::setURL()
     * @uses Campaign::setInfo()
     * @param int $iD
     * @param string $name
     * @param string $uRL
     * @param \StructType\CampaignInfo $info
     */
    public function __construct($iD = null, $name = null, $uRL = null, \StructType\CampaignInfo $info = null)
    {
        $this
            ->setID($iD)
            ->setName($name)
            ->setURL($uRL)
            ->setInfo($info);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\Campaign
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Campaign
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \StructType\Campaign
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRL, true), gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Get info value
     * @return \StructType\CampaignInfo|null
     */
    public function getInfo()
    {
        return $this->info;
    }
    /**
     * Set info value
     * @param \StructType\CampaignInfo $info
     * @return \StructType\Campaign
     */
    public function setInfo(\StructType\CampaignInfo $info = null)
    {
        $this->info = $info;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Campaign
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
