<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Touchpoint StructType
 * @subpackage Structs
 */
class Touchpoint extends AbstractStructBase
{
    /**
     * The affiliateSiteID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $affiliateSiteID;
    /**
     * The siteType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $siteType;
    /**
     * The registrationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $registrationDate;
    /**
     * The numImpressions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $numImpressions;
    /**
     * The numClicks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $numClicks;
    /**
     * The isAttributed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var bool
     */
    public $isAttributed;
    /**
     * The commission
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var float
     */
    public $commission;
    /**
     * The position
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $position;
    /**
     * The reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $reference;
    /**
     * Constructor method for Touchpoint
     * @uses Touchpoint::setAffiliateSiteID()
     * @uses Touchpoint::setSiteType()
     * @uses Touchpoint::setRegistrationDate()
     * @uses Touchpoint::setNumImpressions()
     * @uses Touchpoint::setNumClicks()
     * @uses Touchpoint::setIsAttributed()
     * @uses Touchpoint::setCommission()
     * @uses Touchpoint::setPosition()
     * @uses Touchpoint::setReference()
     * @param int $affiliateSiteID
     * @param string $siteType
     * @param string $registrationDate
     * @param int $numImpressions
     * @param int $numClicks
     * @param bool $isAttributed
     * @param float $commission
     * @param string $position
     * @param string $reference
     */
    public function __construct($affiliateSiteID = null, $siteType = null, $registrationDate = null, $numImpressions = null, $numClicks = null, $isAttributed = null, $commission = null, $position = null, $reference = null)
    {
        $this
            ->setAffiliateSiteID($affiliateSiteID)
            ->setSiteType($siteType)
            ->setRegistrationDate($registrationDate)
            ->setNumImpressions($numImpressions)
            ->setNumClicks($numClicks)
            ->setIsAttributed($isAttributed)
            ->setCommission($commission)
            ->setPosition($position)
            ->setReference($reference);
    }
    /**
     * Get affiliateSiteID value
     * @return int|null
     */
    public function getAffiliateSiteID()
    {
        return $this->affiliateSiteID;
    }
    /**
     * Set affiliateSiteID value
     * @param int $affiliateSiteID
     * @return \StructType\Touchpoint
     */
    public function setAffiliateSiteID($affiliateSiteID = null)
    {
        // validation for constraint: int
        if (!is_null($affiliateSiteID) && !is_numeric($affiliateSiteID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($affiliateSiteID)), __LINE__);
        }
        $this->affiliateSiteID = $affiliateSiteID;
        return $this;
    }
    /**
     * Get siteType value
     * @return string|null
     */
    public function getSiteType()
    {
        return $this->siteType;
    }
    /**
     * Set siteType value
     * @param string $siteType
     * @return \StructType\Touchpoint
     */
    public function setSiteType($siteType = null)
    {
        // validation for constraint: string
        if (!is_null($siteType) && !is_string($siteType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($siteType)), __LINE__);
        }
        $this->siteType = $siteType;
        return $this;
    }
    /**
     * Get registrationDate value
     * @return string|null
     */
    public function getRegistrationDate()
    {
        return $this->registrationDate;
    }
    /**
     * Set registrationDate value
     * @param string $registrationDate
     * @return \StructType\Touchpoint
     */
    public function setRegistrationDate($registrationDate = null)
    {
        // validation for constraint: string
        if (!is_null($registrationDate) && !is_string($registrationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registrationDate)), __LINE__);
        }
        $this->registrationDate = $registrationDate;
        return $this;
    }
    /**
     * Get numImpressions value
     * @return int|null
     */
    public function getNumImpressions()
    {
        return $this->numImpressions;
    }
    /**
     * Set numImpressions value
     * @param int $numImpressions
     * @return \StructType\Touchpoint
     */
    public function setNumImpressions($numImpressions = null)
    {
        // validation for constraint: int
        if (!is_null($numImpressions) && !is_numeric($numImpressions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numImpressions)), __LINE__);
        }
        $this->numImpressions = $numImpressions;
        return $this;
    }
    /**
     * Get numClicks value
     * @return int|null
     */
    public function getNumClicks()
    {
        return $this->numClicks;
    }
    /**
     * Set numClicks value
     * @param int $numClicks
     * @return \StructType\Touchpoint
     */
    public function setNumClicks($numClicks = null)
    {
        // validation for constraint: int
        if (!is_null($numClicks) && !is_numeric($numClicks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numClicks)), __LINE__);
        }
        $this->numClicks = $numClicks;
        return $this;
    }
    /**
     * Get isAttributed value
     * @return bool|null
     */
    public function getIsAttributed()
    {
        return $this->isAttributed;
    }
    /**
     * Set isAttributed value
     * @param bool $isAttributed
     * @return \StructType\Touchpoint
     */
    public function setIsAttributed($isAttributed = null)
    {
        $this->isAttributed = $isAttributed;
        return $this;
    }
    /**
     * Get commission value
     * @return float|null
     */
    public function getCommission()
    {
        return $this->commission;
    }
    /**
     * Set commission value
     * @param float $commission
     * @return \StructType\Touchpoint
     */
    public function setCommission($commission = null)
    {
        $this->commission = $commission;
        return $this;
    }
    /**
     * Get position value
     * @return string|null
     */
    public function getPosition()
    {
        return $this->position;
    }
    /**
     * Set position value
     * @param string $position
     * @return \StructType\Touchpoint
     */
    public function setPosition($position = null)
    {
        // validation for constraint: string
        if (!is_null($position) && !is_string($position)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($position)), __LINE__);
        }
        $this->position = $position;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \StructType\Touchpoint
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Touchpoint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
