<?php

namespace EnumType;

/**
 * This class stands for TransactionConversionSort EnumType
 * @subpackage Enumerations
 */
class TransactionConversionSort
{
    /**
     * Constant for value 'ID'
     * @return string 'ID'
     */
    const VALUE_ID = 'ID';
    /**
     * Constant for value 'assessmentDate'
     * @return string 'assessmentDate'
     */
    const VALUE_ASSESSMENT_DATE = 'assessmentDate';
    /**
     * Constant for value 'registrationDate'
     * @return string 'registrationDate'
     */
    const VALUE_REGISTRATION_DATE = 'registrationDate';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ID
     * @uses self::VALUE_ASSESSMENT_DATE
     * @uses self::VALUE_REGISTRATION_DATE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ID,
            self::VALUE_ASSESSMENT_DATE,
            self::VALUE_REGISTRATION_DATE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
