<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentFilter StructType
 * @subpackage Structs
 */
class PaymentFilter extends AbstractStructBase
{
    /**
     * The billDateFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $billDateFrom;
    /**
     * The billDateTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $billDateTo;
    /**
     * Constructor method for PaymentFilter
     * @uses PaymentFilter::setBillDateFrom()
     * @uses PaymentFilter::setBillDateTo()
     * @param string $billDateFrom
     * @param string $billDateTo
     */
    public function __construct($billDateFrom = null, $billDateTo = null)
    {
        $this
            ->setBillDateFrom($billDateFrom)
            ->setBillDateTo($billDateTo);
    }
    /**
     * Get billDateFrom value
     * @return string|null
     */
    public function getBillDateFrom()
    {
        return $this->billDateFrom;
    }
    /**
     * Set billDateFrom value
     * @param string $billDateFrom
     * @return \StructType\PaymentFilter
     */
    public function setBillDateFrom($billDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($billDateFrom) && !is_string($billDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billDateFrom)), __LINE__);
        }
        $this->billDateFrom = $billDateFrom;
        return $this;
    }
    /**
     * Get billDateTo value
     * @return string|null
     */
    public function getBillDateTo()
    {
        return $this->billDateTo;
    }
    /**
     * Set billDateTo value
     * @param string $billDateTo
     * @return \StructType\PaymentFilter
     */
    public function setBillDateTo($billDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($billDateTo) && !is_string($billDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billDateTo)), __LINE__);
        }
        $this->billDateTo = $billDateTo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
