<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FeedFilter StructType
 * @subpackage Structs
 */
class FeedFilter extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ID;
    /**
     * The campaignID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $campaignID;
    /**
     * The campaignCategoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $campaignCategoryID;
    /**
     * The assignmentStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $assignmentStatus;
    /**
     * Constructor method for FeedFilter
     * @uses FeedFilter::setID()
     * @uses FeedFilter::setCampaignID()
     * @uses FeedFilter::setCampaignCategoryID()
     * @uses FeedFilter::setAssignmentStatus()
     * @param int $iD
     * @param int $campaignID
     * @param int $campaignCategoryID
     * @param string $assignmentStatus
     */
    public function __construct($iD = null, $campaignID = null, $campaignCategoryID = null, $assignmentStatus = null)
    {
        $this
            ->setID($iD)
            ->setCampaignID($campaignID)
            ->setCampaignCategoryID($campaignCategoryID)
            ->setAssignmentStatus($assignmentStatus);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\FeedFilter
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get campaignID value
     * @return int|null
     */
    public function getCampaignID()
    {
        return $this->campaignID;
    }
    /**
     * Set campaignID value
     * @param int $campaignID
     * @return \StructType\FeedFilter
     */
    public function setCampaignID($campaignID = null)
    {
        // validation for constraint: int
        if (!is_null($campaignID) && !is_numeric($campaignID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($campaignID)), __LINE__);
        }
        $this->campaignID = $campaignID;
        return $this;
    }
    /**
     * Get campaignCategoryID value
     * @return int|null
     */
    public function getCampaignCategoryID()
    {
        return $this->campaignCategoryID;
    }
    /**
     * Set campaignCategoryID value
     * @param int $campaignCategoryID
     * @return \StructType\FeedFilter
     */
    public function setCampaignCategoryID($campaignCategoryID = null)
    {
        // validation for constraint: int
        if (!is_null($campaignCategoryID) && !is_numeric($campaignCategoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($campaignCategoryID)), __LINE__);
        }
        $this->campaignCategoryID = $campaignCategoryID;
        return $this;
    }
    /**
     * Get assignmentStatus value
     * @return string|null
     */
    public function getAssignmentStatus()
    {
        return $this->assignmentStatus;
    }
    /**
     * Set assignmentStatus value
     * @uses \EnumType\CampaignAssignmentStatus::valueIsValid()
     * @uses \EnumType\CampaignAssignmentStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $assignmentStatus
     * @return \StructType\FeedFilter
     */
    public function setAssignmentStatus($assignmentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CampaignAssignmentStatus::valueIsValid($assignmentStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $assignmentStatus, implode(', ', \EnumType\CampaignAssignmentStatus::getValidValues())), __LINE__);
        }
        $this->assignmentStatus = $assignmentStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FeedFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
