<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Attributions StructType
 * @subpackage Structs
 */
class Attributions extends AbstractStructBase
{
    /**
     * The affiliateSites
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - arrayType: tns:AttributedAffiliateSite[]
     * - ref: SOAP-ENC:arrayType
     * @var \StructType\AttributedAffiliateSite[]
     */
    public $affiliateSites;
    /**
     * Constructor method for Attributions
     * @uses Attributions::setAffiliateSites()
     * @param \StructType\AttributedAffiliateSite[] $affiliateSites
     */
    public function __construct(array $affiliateSites = array())
    {
        $this
            ->setAffiliateSites($affiliateSites);
    }
    /**
     * Get affiliateSites value
     * @return \StructType\AttributedAffiliateSite[]|null
     */
    public function getAffiliateSites()
    {
        return $this->affiliateSites;
    }
    /**
     * Set affiliateSites value
     * @throws \InvalidArgumentException
     * @param \StructType\AttributedAffiliateSite[] $affiliateSites
     * @return \StructType\Attributions
     */
    public function setAffiliateSites(array $affiliateSites = array())
    {
        foreach ($affiliateSites as $attributionsAffiliateSitesItem) {
            // validation for constraint: itemType
            if (!$attributionsAffiliateSitesItem instanceof \StructType\AttributedAffiliateSite) {
                throw new \InvalidArgumentException(sprintf('The affiliateSites property can only contain items of \StructType\AttributedAffiliateSite, "%s" given', is_object($attributionsAffiliateSitesItem) ? get_class($attributionsAffiliateSitesItem) : gettype($attributionsAffiliateSitesItem)), __LINE__);
            }
        }
        $this->affiliateSites = $affiliateSites;
        return $this;
    }
    /**
     * Add item to affiliateSites value
     * @throws \InvalidArgumentException
     * @param \StructType\AttributedAffiliateSite $item
     * @return \StructType\Attributions
     */
    public function addToAffiliateSites(\StructType\AttributedAffiliateSite $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AttributedAffiliateSite) {
            throw new \InvalidArgumentException(sprintf('The affiliateSites property can only contain items of \StructType\AttributedAffiliateSite, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->affiliateSites[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Attributions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
