<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CampaignFilter StructType
 * @subpackage Structs
 */
class CampaignFilter extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ID;
    /**
     * The query
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $query;
    /**
     * The campaignCategoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $campaignCategoryID;
    /**
     * The assignmentStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $assignmentStatus;
    /**
     * The policySearchEngineMarketingStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $policySearchEngineMarketingStatus;
    /**
     * The policyEmailMarketingStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $policyEmailMarketingStatus;
    /**
     * The policyCashbackStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $policyCashbackStatus;
    /**
     * The policyDiscountCodeStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $policyDiscountCodeStatus;
    /**
     * The limit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $limit;
    /**
     * The offset
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $offset;
    /**
     * The sort
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $sort;
    /**
     * The sortDirection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $sortDirection;
    /**
     * The excludeInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $excludeInfo;
    /**
     * Constructor method for CampaignFilter
     * @uses CampaignFilter::setID()
     * @uses CampaignFilter::setQuery()
     * @uses CampaignFilter::setCampaignCategoryID()
     * @uses CampaignFilter::setAssignmentStatus()
     * @uses CampaignFilter::setPolicySearchEngineMarketingStatus()
     * @uses CampaignFilter::setPolicyEmailMarketingStatus()
     * @uses CampaignFilter::setPolicyCashbackStatus()
     * @uses CampaignFilter::setPolicyDiscountCodeStatus()
     * @uses CampaignFilter::setLimit()
     * @uses CampaignFilter::setOffset()
     * @uses CampaignFilter::setSort()
     * @uses CampaignFilter::setSortDirection()
     * @uses CampaignFilter::setExcludeInfo()
     * @param int $iD
     * @param string $query
     * @param int $campaignCategoryID
     * @param string $assignmentStatus
     * @param string $policySearchEngineMarketingStatus
     * @param string $policyEmailMarketingStatus
     * @param string $policyCashbackStatus
     * @param string $policyDiscountCodeStatus
     * @param int $limit
     * @param int $offset
     * @param string $sort
     * @param string $sortDirection
     * @param bool $excludeInfo
     */
    public function __construct($iD = null, $query = null, $campaignCategoryID = null, $assignmentStatus = null, $policySearchEngineMarketingStatus = null, $policyEmailMarketingStatus = null, $policyCashbackStatus = null, $policyDiscountCodeStatus = null, $limit = null, $offset = null, $sort = null, $sortDirection = null, $excludeInfo = null)
    {
        $this
            ->setID($iD)
            ->setQuery($query)
            ->setCampaignCategoryID($campaignCategoryID)
            ->setAssignmentStatus($assignmentStatus)
            ->setPolicySearchEngineMarketingStatus($policySearchEngineMarketingStatus)
            ->setPolicyEmailMarketingStatus($policyEmailMarketingStatus)
            ->setPolicyCashbackStatus($policyCashbackStatus)
            ->setPolicyDiscountCodeStatus($policyDiscountCodeStatus)
            ->setLimit($limit)
            ->setOffset($offset)
            ->setSort($sort)
            ->setSortDirection($sortDirection)
            ->setExcludeInfo($excludeInfo);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\CampaignFilter
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get query value
     * @return string|null
     */
    public function getQuery()
    {
        return $this->query;
    }
    /**
     * Set query value
     * @param string $query
     * @return \StructType\CampaignFilter
     */
    public function setQuery($query = null)
    {
        // validation for constraint: string
        if (!is_null($query) && !is_string($query)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($query)), __LINE__);
        }
        $this->query = $query;
        return $this;
    }
    /**
     * Get campaignCategoryID value
     * @return int|null
     */
    public function getCampaignCategoryID()
    {
        return $this->campaignCategoryID;
    }
    /**
     * Set campaignCategoryID value
     * @param int $campaignCategoryID
     * @return \StructType\CampaignFilter
     */
    public function setCampaignCategoryID($campaignCategoryID = null)
    {
        // validation for constraint: int
        if (!is_null($campaignCategoryID) && !is_numeric($campaignCategoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($campaignCategoryID)), __LINE__);
        }
        $this->campaignCategoryID = $campaignCategoryID;
        return $this;
    }
    /**
     * Get assignmentStatus value
     * @return string|null
     */
    public function getAssignmentStatus()
    {
        return $this->assignmentStatus;
    }
    /**
     * Set assignmentStatus value
     * @uses \EnumType\CampaignAssignmentStatus::valueIsValid()
     * @uses \EnumType\CampaignAssignmentStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $assignmentStatus
     * @return \StructType\CampaignFilter
     */
    public function setAssignmentStatus($assignmentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CampaignAssignmentStatus::valueIsValid($assignmentStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $assignmentStatus, implode(', ', \EnumType\CampaignAssignmentStatus::getValidValues())), __LINE__);
        }
        $this->assignmentStatus = $assignmentStatus;
        return $this;
    }
    /**
     * Get policySearchEngineMarketingStatus value
     * @return string|null
     */
    public function getPolicySearchEngineMarketingStatus()
    {
        return $this->policySearchEngineMarketingStatus;
    }
    /**
     * Set policySearchEngineMarketingStatus value
     * @uses \EnumType\CampaignAffiliatePolicyStatus::valueIsValid()
     * @uses \EnumType\CampaignAffiliatePolicyStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $policySearchEngineMarketingStatus
     * @return \StructType\CampaignFilter
     */
    public function setPolicySearchEngineMarketingStatus($policySearchEngineMarketingStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CampaignAffiliatePolicyStatus::valueIsValid($policySearchEngineMarketingStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $policySearchEngineMarketingStatus, implode(', ', \EnumType\CampaignAffiliatePolicyStatus::getValidValues())), __LINE__);
        }
        $this->policySearchEngineMarketingStatus = $policySearchEngineMarketingStatus;
        return $this;
    }
    /**
     * Get policyEmailMarketingStatus value
     * @return string|null
     */
    public function getPolicyEmailMarketingStatus()
    {
        return $this->policyEmailMarketingStatus;
    }
    /**
     * Set policyEmailMarketingStatus value
     * @uses \EnumType\CampaignAffiliatePolicyStatus::valueIsValid()
     * @uses \EnumType\CampaignAffiliatePolicyStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $policyEmailMarketingStatus
     * @return \StructType\CampaignFilter
     */
    public function setPolicyEmailMarketingStatus($policyEmailMarketingStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CampaignAffiliatePolicyStatus::valueIsValid($policyEmailMarketingStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $policyEmailMarketingStatus, implode(', ', \EnumType\CampaignAffiliatePolicyStatus::getValidValues())), __LINE__);
        }
        $this->policyEmailMarketingStatus = $policyEmailMarketingStatus;
        return $this;
    }
    /**
     * Get policyCashbackStatus value
     * @return string|null
     */
    public function getPolicyCashbackStatus()
    {
        return $this->policyCashbackStatus;
    }
    /**
     * Set policyCashbackStatus value
     * @uses \EnumType\CampaignAffiliatePolicyStatus::valueIsValid()
     * @uses \EnumType\CampaignAffiliatePolicyStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $policyCashbackStatus
     * @return \StructType\CampaignFilter
     */
    public function setPolicyCashbackStatus($policyCashbackStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CampaignAffiliatePolicyStatus::valueIsValid($policyCashbackStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $policyCashbackStatus, implode(', ', \EnumType\CampaignAffiliatePolicyStatus::getValidValues())), __LINE__);
        }
        $this->policyCashbackStatus = $policyCashbackStatus;
        return $this;
    }
    /**
     * Get policyDiscountCodeStatus value
     * @return string|null
     */
    public function getPolicyDiscountCodeStatus()
    {
        return $this->policyDiscountCodeStatus;
    }
    /**
     * Set policyDiscountCodeStatus value
     * @uses \EnumType\CampaignAffiliatePolicyStatus::valueIsValid()
     * @uses \EnumType\CampaignAffiliatePolicyStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $policyDiscountCodeStatus
     * @return \StructType\CampaignFilter
     */
    public function setPolicyDiscountCodeStatus($policyDiscountCodeStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CampaignAffiliatePolicyStatus::valueIsValid($policyDiscountCodeStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $policyDiscountCodeStatus, implode(', ', \EnumType\CampaignAffiliatePolicyStatus::getValidValues())), __LINE__);
        }
        $this->policyDiscountCodeStatus = $policyDiscountCodeStatus;
        return $this;
    }
    /**
     * Get limit value
     * @return int|null
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param int $limit
     * @return \StructType\CampaignFilter
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Get offset value
     * @return int|null
     */
    public function getOffset()
    {
        return $this->offset;
    }
    /**
     * Set offset value
     * @param int $offset
     * @return \StructType\CampaignFilter
     */
    public function setOffset($offset = null)
    {
        // validation for constraint: int
        if (!is_null($offset) && !is_numeric($offset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($offset)), __LINE__);
        }
        $this->offset = $offset;
        return $this;
    }
    /**
     * Get sort value
     * @return string|null
     */
    public function getSort()
    {
        return $this->sort;
    }
    /**
     * Set sort value
     * @uses \EnumType\CampaignSort::valueIsValid()
     * @uses \EnumType\CampaignSort::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sort
     * @return \StructType\CampaignFilter
     */
    public function setSort($sort = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CampaignSort::valueIsValid($sort)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sort, implode(', ', \EnumType\CampaignSort::getValidValues())), __LINE__);
        }
        $this->sort = $sort;
        return $this;
    }
    /**
     * Get sortDirection value
     * @return string|null
     */
    public function getSortDirection()
    {
        return $this->sortDirection;
    }
    /**
     * Set sortDirection value
     * @uses \EnumType\SortDirection::valueIsValid()
     * @uses \EnumType\SortDirection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sortDirection
     * @return \StructType\CampaignFilter
     */
    public function setSortDirection($sortDirection = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SortDirection::valueIsValid($sortDirection)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sortDirection, implode(', ', \EnumType\SortDirection::getValidValues())), __LINE__);
        }
        $this->sortDirection = $sortDirection;
        return $this;
    }
    /**
     * Get excludeInfo value
     * @return bool|null
     */
    public function getExcludeInfo()
    {
        return $this->excludeInfo;
    }
    /**
     * Set excludeInfo value
     * @param bool $excludeInfo
     * @return \StructType\CampaignFilter
     */
    public function setExcludeInfo($excludeInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeInfo) && !is_bool($excludeInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($excludeInfo)), __LINE__);
        }
        $this->excludeInfo = $excludeInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CampaignFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
