<?php

namespace EnumType;

/**
 * This class stands for CampaignAttributionModel EnumType
 * @subpackage Enumerations
 */
class CampaignAttributionModel
{
    /**
     * Constant for value 'classic'
     * @return string 'classic'
     */
    const VALUE_CLASSIC = 'classic';
    /**
     * Constant for value 'lastTouchpoint'
     * @return string 'lastTouchpoint'
     */
    const VALUE_LAST_TOUCHPOINT = 'lastTouchpoint';
    /**
     * Constant for value 'firstTouchpoint'
     * @return string 'firstTouchpoint'
     */
    const VALUE_FIRST_TOUCHPOINT = 'firstTouchpoint';
    /**
     * Constant for value 'linear'
     * @return string 'linear'
     */
    const VALUE_LINEAR = 'linear';
    /**
     * Constant for value 'timeDecay'
     * @return string 'timeDecay'
     */
    const VALUE_TIME_DECAY = 'timeDecay';
    /**
     * Constant for value 'positionBased'
     * @return string 'positionBased'
     */
    const VALUE_POSITION_BASED = 'positionBased';
    /**
     * Constant for value 'custom'
     * @return string 'custom'
     */
    const VALUE_CUSTOM = 'custom';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CLASSIC
     * @uses self::VALUE_LAST_TOUCHPOINT
     * @uses self::VALUE_FIRST_TOUCHPOINT
     * @uses self::VALUE_LINEAR
     * @uses self::VALUE_TIME_DECAY
     * @uses self::VALUE_POSITION_BASED
     * @uses self::VALUE_CUSTOM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CLASSIC,
            self::VALUE_LAST_TOUCHPOINT,
            self::VALUE_FIRST_TOUCHPOINT,
            self::VALUE_LINEAR,
            self::VALUE_TIME_DECAY,
            self::VALUE_POSITION_BASED,
            self::VALUE_CUSTOM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
