<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CampaignCategory StructType
 * @subpackage Structs
 */
class CampaignCategory extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $ID;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $name;
    /**
     * The categories
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * - arrayType: tns:CampaignCategory[]
     * - ref: SOAP-ENC:arrayType
     * @var \StructType\CampaignCategory[]
     */
    public $categories;
    /**
     * Constructor method for CampaignCategory
     * @uses CampaignCategory::setID()
     * @uses CampaignCategory::setName()
     * @uses CampaignCategory::setCategories()
     * @param int $iD
     * @param string $name
     * @param \StructType\CampaignCategory[] $categories
     */
    public function __construct($iD = null, $name = null, array $categories = array())
    {
        $this
            ->setID($iD)
            ->setName($name)
            ->setCategories($categories);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\CampaignCategory
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\CampaignCategory
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get categories value
     * @return \StructType\CampaignCategory[]|null
     */
    public function getCategories()
    {
        return $this->categories;
    }
    /**
     * Set categories value
     * @throws \InvalidArgumentException
     * @param \StructType\CampaignCategory[] $categories
     * @return \StructType\CampaignCategory
     */
    public function setCategories(array $categories = array())
    {
        foreach ($categories as $campaignCategoryCategoriesItem) {
            // validation for constraint: itemType
            if (!$campaignCategoryCategoriesItem instanceof \StructType\CampaignCategory) {
                throw new \InvalidArgumentException(sprintf('The categories property can only contain items of \StructType\CampaignCategory, "%s" given', is_object($campaignCategoryCategoriesItem) ? get_class($campaignCategoryCategoriesItem) : gettype($campaignCategoryCategoriesItem)), __LINE__);
            }
        }
        $this->categories = $categories;
        return $this;
    }
    /**
     * Add item to categories value
     * @throws \InvalidArgumentException
     * @param \StructType\CampaignCategory $item
     * @return \StructType\CampaignCategory
     */
    public function addToCategories(\StructType\CampaignCategory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CampaignCategory) {
            throw new \InvalidArgumentException(sprintf('The categories property can only contain items of \StructType\CampaignCategory, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->categories[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CampaignCategory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
