<?php

namespace EnumType;

/**
 * This class stands for TransactionType EnumType
 * @subpackage Enumerations
 */
class TransactionType
{
    /**
     * Constant for value 'click'
     * @return string 'click'
     */
    const VALUE_CLICK = 'click';
    /**
     * Constant for value 'lead'
     * @return string 'lead'
     */
    const VALUE_LEAD = 'lead';
    /**
     * Constant for value 'sale'
     * @return string 'sale'
     */
    const VALUE_SALE = 'sale';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CLICK
     * @uses self::VALUE_LEAD
     * @uses self::VALUE_SALE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CLICK,
            self::VALUE_LEAD,
            self::VALUE_SALE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
