<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReportCampaignElement StructType
 * @subpackage Structs
 */
class ReportCampaignElement extends AbstractStructBase
{
    /**
     * The campaign
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var \StructType\Campaign
     */
    public $campaign;
    /**
     * The reportData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var \StructType\ReportData
     */
    public $reportData;
    /**
     * Constructor method for ReportCampaignElement
     * @uses ReportCampaignElement::setCampaign()
     * @uses ReportCampaignElement::setReportData()
     * @param \StructType\Campaign $campaign
     * @param \StructType\ReportData $reportData
     */
    public function __construct(\StructType\Campaign $campaign = null, \StructType\ReportData $reportData = null)
    {
        $this
            ->setCampaign($campaign)
            ->setReportData($reportData);
    }
    /**
     * Get campaign value
     * @return \StructType\Campaign|null
     */
    public function getCampaign()
    {
        return $this->campaign;
    }
    /**
     * Set campaign value
     * @param \StructType\Campaign $campaign
     * @return \StructType\ReportCampaignElement
     */
    public function setCampaign(\StructType\Campaign $campaign = null)
    {
        $this->campaign = $campaign;
        return $this;
    }
    /**
     * Get reportData value
     * @return \StructType\ReportData|null
     */
    public function getReportData()
    {
        return $this->reportData;
    }
    /**
     * Set reportData value
     * @param \StructType\ReportData $reportData
     * @return \StructType\ReportCampaignElement
     */
    public function setReportData(\StructType\ReportData $reportData = null)
    {
        $this->reportData = $reportData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReportCampaignElement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
