<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MaterialItemFilter StructType
 * @subpackage Structs
 */
class MaterialItemFilter extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ID;
    /**
     * The query
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $query;
    /**
     * The campaignID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $campaignID;
    /**
     * The campaignCategoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $campaignCategoryID;
    /**
     * The includeUnsubscribedCampaigns
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $includeUnsubscribedCampaigns;
    /**
     * The materialBannerDimensionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $materialBannerDimensionID;
    /**
     * The reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $reference;
    /**
     * The limit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $limit;
    /**
     * The offset
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $offset;
    /**
     * The sort
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $sort;
    /**
     * The sortDirection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $sortDirection;
    /**
     * Constructor method for MaterialItemFilter
     * @uses MaterialItemFilter::setID()
     * @uses MaterialItemFilter::setQuery()
     * @uses MaterialItemFilter::setCampaignID()
     * @uses MaterialItemFilter::setCampaignCategoryID()
     * @uses MaterialItemFilter::setIncludeUnsubscribedCampaigns()
     * @uses MaterialItemFilter::setMaterialBannerDimensionID()
     * @uses MaterialItemFilter::setReference()
     * @uses MaterialItemFilter::setLimit()
     * @uses MaterialItemFilter::setOffset()
     * @uses MaterialItemFilter::setSort()
     * @uses MaterialItemFilter::setSortDirection()
     * @param int $iD
     * @param string $query
     * @param int $campaignID
     * @param int $campaignCategoryID
     * @param bool $includeUnsubscribedCampaigns
     * @param int $materialBannerDimensionID
     * @param string $reference
     * @param int $limit
     * @param int $offset
     * @param string $sort
     * @param string $sortDirection
     */
    public function __construct($iD = null, $query = null, $campaignID = null, $campaignCategoryID = null, $includeUnsubscribedCampaigns = null, $materialBannerDimensionID = null, $reference = null, $limit = null, $offset = null, $sort = null, $sortDirection = null)
    {
        $this
            ->setID($iD)
            ->setQuery($query)
            ->setCampaignID($campaignID)
            ->setCampaignCategoryID($campaignCategoryID)
            ->setIncludeUnsubscribedCampaigns($includeUnsubscribedCampaigns)
            ->setMaterialBannerDimensionID($materialBannerDimensionID)
            ->setReference($reference)
            ->setLimit($limit)
            ->setOffset($offset)
            ->setSort($sort)
            ->setSortDirection($sortDirection);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\MaterialItemFilter
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get query value
     * @return string|null
     */
    public function getQuery()
    {
        return $this->query;
    }
    /**
     * Set query value
     * @param string $query
     * @return \StructType\MaterialItemFilter
     */
    public function setQuery($query = null)
    {
        // validation for constraint: string
        if (!is_null($query) && !is_string($query)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($query)), __LINE__);
        }
        $this->query = $query;
        return $this;
    }
    /**
     * Get campaignID value
     * @return int|null
     */
    public function getCampaignID()
    {
        return $this->campaignID;
    }
    /**
     * Set campaignID value
     * @param int $campaignID
     * @return \StructType\MaterialItemFilter
     */
    public function setCampaignID($campaignID = null)
    {
        // validation for constraint: int
        if (!is_null($campaignID) && !is_numeric($campaignID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($campaignID)), __LINE__);
        }
        $this->campaignID = $campaignID;
        return $this;
    }
    /**
     * Get campaignCategoryID value
     * @return int|null
     */
    public function getCampaignCategoryID()
    {
        return $this->campaignCategoryID;
    }
    /**
     * Set campaignCategoryID value
     * @param int $campaignCategoryID
     * @return \StructType\MaterialItemFilter
     */
    public function setCampaignCategoryID($campaignCategoryID = null)
    {
        // validation for constraint: int
        if (!is_null($campaignCategoryID) && !is_numeric($campaignCategoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($campaignCategoryID)), __LINE__);
        }
        $this->campaignCategoryID = $campaignCategoryID;
        return $this;
    }
    /**
     * Get includeUnsubscribedCampaigns value
     * @return bool|null
     */
    public function getIncludeUnsubscribedCampaigns()
    {
        return $this->includeUnsubscribedCampaigns;
    }
    /**
     * Set includeUnsubscribedCampaigns value
     * @param bool $includeUnsubscribedCampaigns
     * @return \StructType\MaterialItemFilter
     */
    public function setIncludeUnsubscribedCampaigns($includeUnsubscribedCampaigns = null)
    {
        $this->includeUnsubscribedCampaigns = $includeUnsubscribedCampaigns;
        return $this;
    }
    /**
     * Get materialBannerDimensionID value
     * @return int|null
     */
    public function getMaterialBannerDimensionID()
    {
        return $this->materialBannerDimensionID;
    }
    /**
     * Set materialBannerDimensionID value
     * @param int $materialBannerDimensionID
     * @return \StructType\MaterialItemFilter
     */
    public function setMaterialBannerDimensionID($materialBannerDimensionID = null)
    {
        // validation for constraint: int
        if (!is_null($materialBannerDimensionID) && !is_numeric($materialBannerDimensionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($materialBannerDimensionID)), __LINE__);
        }
        $this->materialBannerDimensionID = $materialBannerDimensionID;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \StructType\MaterialItemFilter
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get limit value
     * @return int|null
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param int $limit
     * @return \StructType\MaterialItemFilter
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Get offset value
     * @return int|null
     */
    public function getOffset()
    {
        return $this->offset;
    }
    /**
     * Set offset value
     * @param int $offset
     * @return \StructType\MaterialItemFilter
     */
    public function setOffset($offset = null)
    {
        // validation for constraint: int
        if (!is_null($offset) && !is_numeric($offset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($offset)), __LINE__);
        }
        $this->offset = $offset;
        return $this;
    }
    /**
     * Get sort value
     * @return string|null
     */
    public function getSort()
    {
        return $this->sort;
    }
    /**
     * Set sort value
     * @uses \EnumType\MaterialItemSort::valueIsValid()
     * @uses \EnumType\MaterialItemSort::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sort
     * @return \StructType\MaterialItemFilter
     */
    public function setSort($sort = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MaterialItemSort::valueIsValid($sort)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sort, implode(', ', \EnumType\MaterialItemSort::getValidValues())), __LINE__);
        }
        $this->sort = $sort;
        return $this;
    }
    /**
     * Get sortDirection value
     * @return string|null
     */
    public function getSortDirection()
    {
        return $this->sortDirection;
    }
    /**
     * Set sortDirection value
     * @uses \EnumType\SortDirection::valueIsValid()
     * @uses \EnumType\SortDirection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sortDirection
     * @return \StructType\MaterialItemFilter
     */
    public function setSortDirection($sortDirection = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SortDirection::valueIsValid($sortDirection)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sortDirection, implode(', ', \EnumType\SortDirection::getValidValues())), __LINE__);
        }
        $this->sortDirection = $sortDirection;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MaterialItemFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
