<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateConversionTransactionOptions StructType
 * @subpackage Structs
 */
class CreateConversionTransactionOptions extends AbstractStructBase
{
    /**
     * The campaignID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $campaignID;
    /**
     * The campaignProductID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $campaignProductID;
    /**
     * The characteristic
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $characteristic;
    /**
     * The remarks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $remarks;
    /**
     * The reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $reference;
    /**
     * The transactionAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var float
     */
    public $transactionAmount;
    /**
     * Constructor method for CreateConversionTransactionOptions
     * @uses CreateConversionTransactionOptions::setCampaignID()
     * @uses CreateConversionTransactionOptions::setCampaignProductID()
     * @uses CreateConversionTransactionOptions::setCharacteristic()
     * @uses CreateConversionTransactionOptions::setRemarks()
     * @uses CreateConversionTransactionOptions::setReference()
     * @uses CreateConversionTransactionOptions::setTransactionAmount()
     * @param int $campaignID
     * @param int $campaignProductID
     * @param string $characteristic
     * @param string $remarks
     * @param string $reference
     * @param float $transactionAmount
     */
    public function __construct($campaignID = null, $campaignProductID = null, $characteristic = null, $remarks = null, $reference = null, $transactionAmount = null)
    {
        $this
            ->setCampaignID($campaignID)
            ->setCampaignProductID($campaignProductID)
            ->setCharacteristic($characteristic)
            ->setRemarks($remarks)
            ->setReference($reference)
            ->setTransactionAmount($transactionAmount);
    }
    /**
     * Get campaignID value
     * @return int|null
     */
    public function getCampaignID()
    {
        return $this->campaignID;
    }
    /**
     * Set campaignID value
     * @param int $campaignID
     * @return \StructType\CreateConversionTransactionOptions
     */
    public function setCampaignID($campaignID = null)
    {
        // validation for constraint: int
        if (!is_null($campaignID) && !is_numeric($campaignID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($campaignID)), __LINE__);
        }
        $this->campaignID = $campaignID;
        return $this;
    }
    /**
     * Get campaignProductID value
     * @return int|null
     */
    public function getCampaignProductID()
    {
        return $this->campaignProductID;
    }
    /**
     * Set campaignProductID value
     * @param int $campaignProductID
     * @return \StructType\CreateConversionTransactionOptions
     */
    public function setCampaignProductID($campaignProductID = null)
    {
        // validation for constraint: int
        if (!is_null($campaignProductID) && !is_numeric($campaignProductID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($campaignProductID)), __LINE__);
        }
        $this->campaignProductID = $campaignProductID;
        return $this;
    }
    /**
     * Get characteristic value
     * @return string|null
     */
    public function getCharacteristic()
    {
        return $this->characteristic;
    }
    /**
     * Set characteristic value
     * @param string $characteristic
     * @return \StructType\CreateConversionTransactionOptions
     */
    public function setCharacteristic($characteristic = null)
    {
        // validation for constraint: string
        if (!is_null($characteristic) && !is_string($characteristic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($characteristic)), __LINE__);
        }
        $this->characteristic = $characteristic;
        return $this;
    }
    /**
     * Get remarks value
     * @return string|null
     */
    public function getRemarks()
    {
        return $this->remarks;
    }
    /**
     * Set remarks value
     * @param string $remarks
     * @return \StructType\CreateConversionTransactionOptions
     */
    public function setRemarks($remarks = null)
    {
        // validation for constraint: string
        if (!is_null($remarks) && !is_string($remarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remarks)), __LINE__);
        }
        $this->remarks = $remarks;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \StructType\CreateConversionTransactionOptions
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get transactionAmount value
     * @return float|null
     */
    public function getTransactionAmount()
    {
        return $this->transactionAmount;
    }
    /**
     * Set transactionAmount value
     * @param float $transactionAmount
     * @return \StructType\CreateConversionTransactionOptions
     */
    public function setTransactionAmount($transactionAmount = null)
    {
        $this->transactionAmount = $transactionAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateConversionTransactionOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
