<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClickTransactionFilter StructType
 * @subpackage Structs
 */
class ClickTransactionFilter extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ID;
    /**
     * The transactionStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $transactionStatus;
    /**
     * The registrationDateFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $registrationDateFrom;
    /**
     * The registrationDateTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $registrationDateTo;
    /**
     * The reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $reference;
    /**
     * The limit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $limit;
    /**
     * The offset
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $offset;
    /**
     * Constructor method for ClickTransactionFilter
     * @uses ClickTransactionFilter::setID()
     * @uses ClickTransactionFilter::setTransactionStatus()
     * @uses ClickTransactionFilter::setRegistrationDateFrom()
     * @uses ClickTransactionFilter::setRegistrationDateTo()
     * @uses ClickTransactionFilter::setReference()
     * @uses ClickTransactionFilter::setLimit()
     * @uses ClickTransactionFilter::setOffset()
     * @param int $iD
     * @param string $transactionStatus
     * @param string $registrationDateFrom
     * @param string $registrationDateTo
     * @param string $reference
     * @param int $limit
     * @param int $offset
     */
    public function __construct($iD = null, $transactionStatus = null, $registrationDateFrom = null, $registrationDateTo = null, $reference = null, $limit = null, $offset = null)
    {
        $this
            ->setID($iD)
            ->setTransactionStatus($transactionStatus)
            ->setRegistrationDateFrom($registrationDateFrom)
            ->setRegistrationDateTo($registrationDateTo)
            ->setReference($reference)
            ->setLimit($limit)
            ->setOffset($offset);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\ClickTransactionFilter
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get transactionStatus value
     * @return string|null
     */
    public function getTransactionStatus()
    {
        return $this->transactionStatus;
    }
    /**
     * Set transactionStatus value
     * @uses \EnumType\TransactionStatus::valueIsValid()
     * @uses \EnumType\TransactionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionStatus
     * @return \StructType\ClickTransactionFilter
     */
    public function setTransactionStatus($transactionStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransactionStatus::valueIsValid($transactionStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transactionStatus, implode(', ', \EnumType\TransactionStatus::getValidValues())), __LINE__);
        }
        $this->transactionStatus = $transactionStatus;
        return $this;
    }
    /**
     * Get registrationDateFrom value
     * @return string|null
     */
    public function getRegistrationDateFrom()
    {
        return $this->registrationDateFrom;
    }
    /**
     * Set registrationDateFrom value
     * @param string $registrationDateFrom
     * @return \StructType\ClickTransactionFilter
     */
    public function setRegistrationDateFrom($registrationDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($registrationDateFrom) && !is_string($registrationDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registrationDateFrom)), __LINE__);
        }
        $this->registrationDateFrom = $registrationDateFrom;
        return $this;
    }
    /**
     * Get registrationDateTo value
     * @return string|null
     */
    public function getRegistrationDateTo()
    {
        return $this->registrationDateTo;
    }
    /**
     * Set registrationDateTo value
     * @param string $registrationDateTo
     * @return \StructType\ClickTransactionFilter
     */
    public function setRegistrationDateTo($registrationDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($registrationDateTo) && !is_string($registrationDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registrationDateTo)), __LINE__);
        }
        $this->registrationDateTo = $registrationDateTo;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \StructType\ClickTransactionFilter
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get limit value
     * @return int|null
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param int $limit
     * @return \StructType\ClickTransactionFilter
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Get offset value
     * @return int|null
     */
    public function getOffset()
    {
        return $this->offset;
    }
    /**
     * Set offset value
     * @param int $offset
     * @return \StructType\ClickTransactionFilter
     */
    public function setOffset($offset = null)
    {
        // validation for constraint: int
        if (!is_null($offset) && !is_numeric($offset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($offset)), __LINE__);
        }
        $this->offset = $offset;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClickTransactionFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
