<?php

namespace EnumType;

/**
 * This class stands for CampaignSubscriptionAction EnumType
 * @subpackage Enumerations
 */
class CampaignSubscriptionAction
{
    /**
     * Constant for value 'subscribe'
     * @return string 'subscribe'
     */
    const VALUE_SUBSCRIBE = 'subscribe';
    /**
     * Constant for value 'unsubscribe'
     * @return string 'unsubscribe'
     */
    const VALUE_UNSUBSCRIBE = 'unsubscribe';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SUBSCRIBE
     * @uses self::VALUE_UNSUBSCRIBE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SUBSCRIBE,
            self::VALUE_UNSUBSCRIBE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
