<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CampaignNewsItemFilter StructType
 * @subpackage Structs
 */
class CampaignNewsItemFilter extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ID;
    /**
     * The query
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $query;
    /**
     * The campaignCategoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $campaignCategoryID;
    /**
     * The campaignNewsType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $campaignNewsType;
    /**
     * The limit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $limit;
    /**
     * The offset
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $offset;
    /**
     * Constructor method for CampaignNewsItemFilter
     * @uses CampaignNewsItemFilter::setID()
     * @uses CampaignNewsItemFilter::setQuery()
     * @uses CampaignNewsItemFilter::setCampaignCategoryID()
     * @uses CampaignNewsItemFilter::setCampaignNewsType()
     * @uses CampaignNewsItemFilter::setLimit()
     * @uses CampaignNewsItemFilter::setOffset()
     * @param int $iD
     * @param string $query
     * @param int $campaignCategoryID
     * @param string $campaignNewsType
     * @param int $limit
     * @param int $offset
     */
    public function __construct($iD = null, $query = null, $campaignCategoryID = null, $campaignNewsType = null, $limit = null, $offset = null)
    {
        $this
            ->setID($iD)
            ->setQuery($query)
            ->setCampaignCategoryID($campaignCategoryID)
            ->setCampaignNewsType($campaignNewsType)
            ->setLimit($limit)
            ->setOffset($offset);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\CampaignNewsItemFilter
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get query value
     * @return string|null
     */
    public function getQuery()
    {
        return $this->query;
    }
    /**
     * Set query value
     * @param string $query
     * @return \StructType\CampaignNewsItemFilter
     */
    public function setQuery($query = null)
    {
        // validation for constraint: string
        if (!is_null($query) && !is_string($query)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($query)), __LINE__);
        }
        $this->query = $query;
        return $this;
    }
    /**
     * Get campaignCategoryID value
     * @return int|null
     */
    public function getCampaignCategoryID()
    {
        return $this->campaignCategoryID;
    }
    /**
     * Set campaignCategoryID value
     * @param int $campaignCategoryID
     * @return \StructType\CampaignNewsItemFilter
     */
    public function setCampaignCategoryID($campaignCategoryID = null)
    {
        // validation for constraint: int
        if (!is_null($campaignCategoryID) && !is_numeric($campaignCategoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($campaignCategoryID)), __LINE__);
        }
        $this->campaignCategoryID = $campaignCategoryID;
        return $this;
    }
    /**
     * Get campaignNewsType value
     * @return string|null
     */
    public function getCampaignNewsType()
    {
        return $this->campaignNewsType;
    }
    /**
     * Set campaignNewsType value
     * @uses \EnumType\CampaignNewsType::valueIsValid()
     * @uses \EnumType\CampaignNewsType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $campaignNewsType
     * @return \StructType\CampaignNewsItemFilter
     */
    public function setCampaignNewsType($campaignNewsType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CampaignNewsType::valueIsValid($campaignNewsType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $campaignNewsType, implode(', ', \EnumType\CampaignNewsType::getValidValues())), __LINE__);
        }
        $this->campaignNewsType = $campaignNewsType;
        return $this;
    }
    /**
     * Get limit value
     * @return int|null
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param int $limit
     * @return \StructType\CampaignNewsItemFilter
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Get offset value
     * @return int|null
     */
    public function getOffset()
    {
        return $this->offset;
    }
    /**
     * Set offset value
     * @param int $offset
     * @return \StructType\CampaignNewsItemFilter
     */
    public function setOffset($offset = null)
    {
        // validation for constraint: int
        if (!is_null($offset) && !is_numeric($offset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($offset)), __LINE__);
        }
        $this->offset = $offset;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CampaignNewsItemFilter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
