<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CampaignInfo StructType
 * @subpackage Structs
 */
class CampaignInfo extends AbstractStructBase
{
    /**
     * The category
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var \StructType\CampaignCategory
     */
    public $category;
    /**
     * The subCategories
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * - arrayType: tns:CampaignSubCategory[]
     * - ref: SOAP-ENC:arrayType
     * @var CampaignSubCategory
     */
    public $subCategories;
    /**
     * The campaignDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $campaignDescription;
    /**
     * The shopDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $shopDescription;
    /**
     * The targetGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $targetGroup;
    /**
     * The characteristics
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $characteristics;
    /**
     * The imageURL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $imageURL;
    /**
     * The trackingURL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $trackingURL;
    /**
     * The commission
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var \StructType\CampaignCommission
     */
    public $commission;
    /**
     * The assignmentStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $assignmentStatus;
    /**
     * The startDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $startDate;
    /**
     * The stopDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $stopDate;
    /**
     * The clickToConversion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $clickToConversion;
    /**
     * The policySearchEngineMarketingStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $policySearchEngineMarketingStatus;
    /**
     * The policyEmailMarketingStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $policyEmailMarketingStatus;
    /**
     * The policyCashbackStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $policyCashbackStatus;
    /**
     * The policyDiscountCodeStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $policyDiscountCodeStatus;
    /**
     * The deeplinkingSupported
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var bool
     */
    public $deeplinkingSupported;
    /**
     * The referencesSupported
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var bool
     */
    public $referencesSupported;
    /**
     * The leadMaximumAssessmentInterval
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $leadMaximumAssessmentInterval;
    /**
     * The leadAverageAssessmentInterval
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $leadAverageAssessmentInterval;
    /**
     * The saleMaximumAssessmentInterval
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $saleMaximumAssessmentInterval;
    /**
     * The saleAverageAssessmentInterval
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $saleAverageAssessmentInterval;
    /**
     * The attributionModelLead
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $attributionModelLead;
    /**
     * The attributionModelSales
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $attributionModelSales;
    /**
     * Constructor method for CampaignInfo
     * @uses CampaignInfo::setCategory()
     * @uses CampaignInfo::setSubCategories()
     * @uses CampaignInfo::setCampaignDescription()
     * @uses CampaignInfo::setShopDescription()
     * @uses CampaignInfo::setTargetGroup()
     * @uses CampaignInfo::setCharacteristics()
     * @uses CampaignInfo::setImageURL()
     * @uses CampaignInfo::setTrackingURL()
     * @uses CampaignInfo::setCommission()
     * @uses CampaignInfo::setAssignmentStatus()
     * @uses CampaignInfo::setStartDate()
     * @uses CampaignInfo::setStopDate()
     * @uses CampaignInfo::setClickToConversion()
     * @uses CampaignInfo::setPolicySearchEngineMarketingStatus()
     * @uses CampaignInfo::setPolicyEmailMarketingStatus()
     * @uses CampaignInfo::setPolicyCashbackStatus()
     * @uses CampaignInfo::setPolicyDiscountCodeStatus()
     * @uses CampaignInfo::setDeeplinkingSupported()
     * @uses CampaignInfo::setReferencesSupported()
     * @uses CampaignInfo::setLeadMaximumAssessmentInterval()
     * @uses CampaignInfo::setLeadAverageAssessmentInterval()
     * @uses CampaignInfo::setSaleMaximumAssessmentInterval()
     * @uses CampaignInfo::setSaleAverageAssessmentInterval()
     * @uses CampaignInfo::setAttributionModelLead()
     * @uses CampaignInfo::setAttributionModelSales()
     * @param \StructType\CampaignCategory $category
     * @param CampaignSubCategory $subCategories
     * @param string $campaignDescription
     * @param string $shopDescription
     * @param string $targetGroup
     * @param string $characteristics
     * @param string $imageURL
     * @param string $trackingURL
     * @param \StructType\CampaignCommission $commission
     * @param string $assignmentStatus
     * @param string $startDate
     * @param string $stopDate
     * @param string $clickToConversion
     * @param string $policySearchEngineMarketingStatus
     * @param string $policyEmailMarketingStatus
     * @param string $policyCashbackStatus
     * @param string $policyDiscountCodeStatus
     * @param bool $deeplinkingSupported
     * @param bool $referencesSupported
     * @param string $leadMaximumAssessmentInterval
     * @param string $leadAverageAssessmentInterval
     * @param string $saleMaximumAssessmentInterval
     * @param string $saleAverageAssessmentInterval
     * @param string $attributionModelLead
     * @param string $attributionModelSales
     */
    public function __construct(\StructType\CampaignCategory $category = null, CampaignSubCategory $subCategories = null, $campaignDescription = null, $shopDescription = null, $targetGroup = null, $characteristics = null, $imageURL = null, $trackingURL = null, \StructType\CampaignCommission $commission = null, $assignmentStatus = null, $startDate = null, $stopDate = null, $clickToConversion = null, $policySearchEngineMarketingStatus = null, $policyEmailMarketingStatus = null, $policyCashbackStatus = null, $policyDiscountCodeStatus = null, $deeplinkingSupported = null, $referencesSupported = null, $leadMaximumAssessmentInterval = null, $leadAverageAssessmentInterval = null, $saleMaximumAssessmentInterval = null, $saleAverageAssessmentInterval = null, $attributionModelLead = null, $attributionModelSales = null)
    {
        $this
            ->setCategory($category)
            ->setSubCategories($subCategories)
            ->setCampaignDescription($campaignDescription)
            ->setShopDescription($shopDescription)
            ->setTargetGroup($targetGroup)
            ->setCharacteristics($characteristics)
            ->setImageURL($imageURL)
            ->setTrackingURL($trackingURL)
            ->setCommission($commission)
            ->setAssignmentStatus($assignmentStatus)
            ->setStartDate($startDate)
            ->setStopDate($stopDate)
            ->setClickToConversion($clickToConversion)
            ->setPolicySearchEngineMarketingStatus($policySearchEngineMarketingStatus)
            ->setPolicyEmailMarketingStatus($policyEmailMarketingStatus)
            ->setPolicyCashbackStatus($policyCashbackStatus)
            ->setPolicyDiscountCodeStatus($policyDiscountCodeStatus)
            ->setDeeplinkingSupported($deeplinkingSupported)
            ->setReferencesSupported($referencesSupported)
            ->setLeadMaximumAssessmentInterval($leadMaximumAssessmentInterval)
            ->setLeadAverageAssessmentInterval($leadAverageAssessmentInterval)
            ->setSaleMaximumAssessmentInterval($saleMaximumAssessmentInterval)
            ->setSaleAverageAssessmentInterval($saleAverageAssessmentInterval)
            ->setAttributionModelLead($attributionModelLead)
            ->setAttributionModelSales($attributionModelSales);
    }
    /**
     * Get category value
     * @return \StructType\CampaignCategory|null
     */
    public function getCategory()
    {
        return $this->category;
    }
    /**
     * Set category value
     * @param \StructType\CampaignCategory $category
     * @return \StructType\CampaignInfo
     */
    public function setCategory(\StructType\CampaignCategory $category = null)
    {
        $this->category = $category;
        return $this;
    }
    /**
     * Get subCategories value
     * @return CampaignSubCategory|null
     */
    public function getSubCategories()
    {
        return $this->subCategories;
    }
    /**
     * Set subCategories value
     * @param CampaignSubCategory $subCategories
     * @return \StructType\CampaignInfo
     */
    public function setSubCategories(CampaignSubCategory $subCategories = null)
    {
        $this->subCategories = $subCategories;
        return $this;
    }
    /**
     * Get campaignDescription value
     * @return string|null
     */
    public function getCampaignDescription()
    {
        return $this->campaignDescription;
    }
    /**
     * Set campaignDescription value
     * @param string $campaignDescription
     * @return \StructType\CampaignInfo
     */
    public function setCampaignDescription($campaignDescription = null)
    {
        // validation for constraint: string
        if (!is_null($campaignDescription) && !is_string($campaignDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($campaignDescription)), __LINE__);
        }
        $this->campaignDescription = $campaignDescription;
        return $this;
    }
    /**
     * Get shopDescription value
     * @return string|null
     */
    public function getShopDescription()
    {
        return $this->shopDescription;
    }
    /**
     * Set shopDescription value
     * @param string $shopDescription
     * @return \StructType\CampaignInfo
     */
    public function setShopDescription($shopDescription = null)
    {
        // validation for constraint: string
        if (!is_null($shopDescription) && !is_string($shopDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shopDescription)), __LINE__);
        }
        $this->shopDescription = $shopDescription;
        return $this;
    }
    /**
     * Get targetGroup value
     * @return string|null
     */
    public function getTargetGroup()
    {
        return $this->targetGroup;
    }
    /**
     * Set targetGroup value
     * @param string $targetGroup
     * @return \StructType\CampaignInfo
     */
    public function setTargetGroup($targetGroup = null)
    {
        // validation for constraint: string
        if (!is_null($targetGroup) && !is_string($targetGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($targetGroup)), __LINE__);
        }
        $this->targetGroup = $targetGroup;
        return $this;
    }
    /**
     * Get characteristics value
     * @return string|null
     */
    public function getCharacteristics()
    {
        return $this->characteristics;
    }
    /**
     * Set characteristics value
     * @param string $characteristics
     * @return \StructType\CampaignInfo
     */
    public function setCharacteristics($characteristics = null)
    {
        // validation for constraint: string
        if (!is_null($characteristics) && !is_string($characteristics)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($characteristics)), __LINE__);
        }
        $this->characteristics = $characteristics;
        return $this;
    }
    /**
     * Get imageURL value
     * @return string|null
     */
    public function getImageURL()
    {
        return $this->imageURL;
    }
    /**
     * Set imageURL value
     * @param string $imageURL
     * @return \StructType\CampaignInfo
     */
    public function setImageURL($imageURL = null)
    {
        // validation for constraint: string
        if (!is_null($imageURL) && !is_string($imageURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imageURL)), __LINE__);
        }
        $this->imageURL = $imageURL;
        return $this;
    }
    /**
     * Get trackingURL value
     * @return string|null
     */
    public function getTrackingURL()
    {
        return $this->trackingURL;
    }
    /**
     * Set trackingURL value
     * @param string $trackingURL
     * @return \StructType\CampaignInfo
     */
    public function setTrackingURL($trackingURL = null)
    {
        // validation for constraint: string
        if (!is_null($trackingURL) && !is_string($trackingURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trackingURL)), __LINE__);
        }
        $this->trackingURL = $trackingURL;
        return $this;
    }
    /**
     * Get commission value
     * @return \StructType\CampaignCommission|null
     */
    public function getCommission()
    {
        return $this->commission;
    }
    /**
     * Set commission value
     * @param \StructType\CampaignCommission $commission
     * @return \StructType\CampaignInfo
     */
    public function setCommission(\StructType\CampaignCommission $commission = null)
    {
        $this->commission = $commission;
        return $this;
    }
    /**
     * Get assignmentStatus value
     * @return string|null
     */
    public function getAssignmentStatus()
    {
        return $this->assignmentStatus;
    }
    /**
     * Set assignmentStatus value
     * @uses \EnumType\CampaignAssignmentStatus::valueIsValid()
     * @uses \EnumType\CampaignAssignmentStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $assignmentStatus
     * @return \StructType\CampaignInfo
     */
    public function setAssignmentStatus($assignmentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CampaignAssignmentStatus::valueIsValid($assignmentStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $assignmentStatus, implode(', ', \EnumType\CampaignAssignmentStatus::getValidValues())), __LINE__);
        }
        $this->assignmentStatus = $assignmentStatus;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\CampaignInfo
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get stopDate value
     * @return string|null
     */
    public function getStopDate()
    {
        return $this->stopDate;
    }
    /**
     * Set stopDate value
     * @param string $stopDate
     * @return \StructType\CampaignInfo
     */
    public function setStopDate($stopDate = null)
    {
        // validation for constraint: string
        if (!is_null($stopDate) && !is_string($stopDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stopDate)), __LINE__);
        }
        $this->stopDate = $stopDate;
        return $this;
    }
    /**
     * Get clickToConversion value
     * @return string|null
     */
    public function getClickToConversion()
    {
        return $this->clickToConversion;
    }
    /**
     * Set clickToConversion value
     * @param string $clickToConversion
     * @return \StructType\CampaignInfo
     */
    public function setClickToConversion($clickToConversion = null)
    {
        // validation for constraint: string
        if (!is_null($clickToConversion) && !is_string($clickToConversion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clickToConversion)), __LINE__);
        }
        $this->clickToConversion = $clickToConversion;
        return $this;
    }
    /**
     * Get policySearchEngineMarketingStatus value
     * @return string|null
     */
    public function getPolicySearchEngineMarketingStatus()
    {
        return $this->policySearchEngineMarketingStatus;
    }
    /**
     * Set policySearchEngineMarketingStatus value
     * @uses \EnumType\CampaignAffiliatePolicyStatus::valueIsValid()
     * @uses \EnumType\CampaignAffiliatePolicyStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $policySearchEngineMarketingStatus
     * @return \StructType\CampaignInfo
     */
    public function setPolicySearchEngineMarketingStatus($policySearchEngineMarketingStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CampaignAffiliatePolicyStatus::valueIsValid($policySearchEngineMarketingStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $policySearchEngineMarketingStatus, implode(', ', \EnumType\CampaignAffiliatePolicyStatus::getValidValues())), __LINE__);
        }
        $this->policySearchEngineMarketingStatus = $policySearchEngineMarketingStatus;
        return $this;
    }
    /**
     * Get policyEmailMarketingStatus value
     * @return string|null
     */
    public function getPolicyEmailMarketingStatus()
    {
        return $this->policyEmailMarketingStatus;
    }
    /**
     * Set policyEmailMarketingStatus value
     * @uses \EnumType\CampaignAffiliatePolicyStatus::valueIsValid()
     * @uses \EnumType\CampaignAffiliatePolicyStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $policyEmailMarketingStatus
     * @return \StructType\CampaignInfo
     */
    public function setPolicyEmailMarketingStatus($policyEmailMarketingStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CampaignAffiliatePolicyStatus::valueIsValid($policyEmailMarketingStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $policyEmailMarketingStatus, implode(', ', \EnumType\CampaignAffiliatePolicyStatus::getValidValues())), __LINE__);
        }
        $this->policyEmailMarketingStatus = $policyEmailMarketingStatus;
        return $this;
    }
    /**
     * Get policyCashbackStatus value
     * @return string|null
     */
    public function getPolicyCashbackStatus()
    {
        return $this->policyCashbackStatus;
    }
    /**
     * Set policyCashbackStatus value
     * @uses \EnumType\CampaignAffiliatePolicyStatus::valueIsValid()
     * @uses \EnumType\CampaignAffiliatePolicyStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $policyCashbackStatus
     * @return \StructType\CampaignInfo
     */
    public function setPolicyCashbackStatus($policyCashbackStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CampaignAffiliatePolicyStatus::valueIsValid($policyCashbackStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $policyCashbackStatus, implode(', ', \EnumType\CampaignAffiliatePolicyStatus::getValidValues())), __LINE__);
        }
        $this->policyCashbackStatus = $policyCashbackStatus;
        return $this;
    }
    /**
     * Get policyDiscountCodeStatus value
     * @return string|null
     */
    public function getPolicyDiscountCodeStatus()
    {
        return $this->policyDiscountCodeStatus;
    }
    /**
     * Set policyDiscountCodeStatus value
     * @uses \EnumType\CampaignAffiliatePolicyStatus::valueIsValid()
     * @uses \EnumType\CampaignAffiliatePolicyStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $policyDiscountCodeStatus
     * @return \StructType\CampaignInfo
     */
    public function setPolicyDiscountCodeStatus($policyDiscountCodeStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CampaignAffiliatePolicyStatus::valueIsValid($policyDiscountCodeStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $policyDiscountCodeStatus, implode(', ', \EnumType\CampaignAffiliatePolicyStatus::getValidValues())), __LINE__);
        }
        $this->policyDiscountCodeStatus = $policyDiscountCodeStatus;
        return $this;
    }
    /**
     * Get deeplinkingSupported value
     * @return bool|null
     */
    public function getDeeplinkingSupported()
    {
        return $this->deeplinkingSupported;
    }
    /**
     * Set deeplinkingSupported value
     * @param bool $deeplinkingSupported
     * @return \StructType\CampaignInfo
     */
    public function setDeeplinkingSupported($deeplinkingSupported = null)
    {
        $this->deeplinkingSupported = $deeplinkingSupported;
        return $this;
    }
    /**
     * Get referencesSupported value
     * @return bool|null
     */
    public function getReferencesSupported()
    {
        return $this->referencesSupported;
    }
    /**
     * Set referencesSupported value
     * @param bool $referencesSupported
     * @return \StructType\CampaignInfo
     */
    public function setReferencesSupported($referencesSupported = null)
    {
        $this->referencesSupported = $referencesSupported;
        return $this;
    }
    /**
     * Get leadMaximumAssessmentInterval value
     * @return string|null
     */
    public function getLeadMaximumAssessmentInterval()
    {
        return $this->leadMaximumAssessmentInterval;
    }
    /**
     * Set leadMaximumAssessmentInterval value
     * @param string $leadMaximumAssessmentInterval
     * @return \StructType\CampaignInfo
     */
    public function setLeadMaximumAssessmentInterval($leadMaximumAssessmentInterval = null)
    {
        // validation for constraint: string
        if (!is_null($leadMaximumAssessmentInterval) && !is_string($leadMaximumAssessmentInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($leadMaximumAssessmentInterval)), __LINE__);
        }
        $this->leadMaximumAssessmentInterval = $leadMaximumAssessmentInterval;
        return $this;
    }
    /**
     * Get leadAverageAssessmentInterval value
     * @return string|null
     */
    public function getLeadAverageAssessmentInterval()
    {
        return $this->leadAverageAssessmentInterval;
    }
    /**
     * Set leadAverageAssessmentInterval value
     * @param string $leadAverageAssessmentInterval
     * @return \StructType\CampaignInfo
     */
    public function setLeadAverageAssessmentInterval($leadAverageAssessmentInterval = null)
    {
        // validation for constraint: string
        if (!is_null($leadAverageAssessmentInterval) && !is_string($leadAverageAssessmentInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($leadAverageAssessmentInterval)), __LINE__);
        }
        $this->leadAverageAssessmentInterval = $leadAverageAssessmentInterval;
        return $this;
    }
    /**
     * Get saleMaximumAssessmentInterval value
     * @return string|null
     */
    public function getSaleMaximumAssessmentInterval()
    {
        return $this->saleMaximumAssessmentInterval;
    }
    /**
     * Set saleMaximumAssessmentInterval value
     * @param string $saleMaximumAssessmentInterval
     * @return \StructType\CampaignInfo
     */
    public function setSaleMaximumAssessmentInterval($saleMaximumAssessmentInterval = null)
    {
        // validation for constraint: string
        if (!is_null($saleMaximumAssessmentInterval) && !is_string($saleMaximumAssessmentInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($saleMaximumAssessmentInterval)), __LINE__);
        }
        $this->saleMaximumAssessmentInterval = $saleMaximumAssessmentInterval;
        return $this;
    }
    /**
     * Get saleAverageAssessmentInterval value
     * @return string|null
     */
    public function getSaleAverageAssessmentInterval()
    {
        return $this->saleAverageAssessmentInterval;
    }
    /**
     * Set saleAverageAssessmentInterval value
     * @param string $saleAverageAssessmentInterval
     * @return \StructType\CampaignInfo
     */
    public function setSaleAverageAssessmentInterval($saleAverageAssessmentInterval = null)
    {
        // validation for constraint: string
        if (!is_null($saleAverageAssessmentInterval) && !is_string($saleAverageAssessmentInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($saleAverageAssessmentInterval)), __LINE__);
        }
        $this->saleAverageAssessmentInterval = $saleAverageAssessmentInterval;
        return $this;
    }
    /**
     * Get attributionModelLead value
     * @return string|null
     */
    public function getAttributionModelLead()
    {
        return $this->attributionModelLead;
    }
    /**
     * Set attributionModelLead value
     * @uses \EnumType\CampaignAttributionModel::valueIsValid()
     * @uses \EnumType\CampaignAttributionModel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $attributionModelLead
     * @return \StructType\CampaignInfo
     */
    public function setAttributionModelLead($attributionModelLead = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CampaignAttributionModel::valueIsValid($attributionModelLead)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $attributionModelLead, implode(', ', \EnumType\CampaignAttributionModel::getValidValues())), __LINE__);
        }
        $this->attributionModelLead = $attributionModelLead;
        return $this;
    }
    /**
     * Get attributionModelSales value
     * @return string|null
     */
    public function getAttributionModelSales()
    {
        return $this->attributionModelSales;
    }
    /**
     * Set attributionModelSales value
     * @uses \EnumType\CampaignAttributionModel::valueIsValid()
     * @uses \EnumType\CampaignAttributionModel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $attributionModelSales
     * @return \StructType\CampaignInfo
     */
    public function setAttributionModelSales($attributionModelSales = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CampaignAttributionModel::valueIsValid($attributionModelSales)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $attributionModelSales, implode(', ', \EnumType\CampaignAttributionModel::getValidValues())), __LINE__);
        }
        $this->attributionModelSales = $attributionModelSales;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CampaignInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
