<?php

namespace EnumType;

/**
 * This class stands for CampaignAffiliatePolicyStatus EnumType
 * @subpackage Enumerations
 */
class CampaignAffiliatePolicyStatus
{
    /**
     * Constant for value 'allowed'
     * @return string 'allowed'
     */
    const VALUE_ALLOWED = 'allowed';
    /**
     * Constant for value 'limited'
     * @return string 'limited'
     */
    const VALUE_LIMITED = 'limited';
    /**
     * Constant for value 'disallowed'
     * @return string 'disallowed'
     */
    const VALUE_DISALLOWED = 'disallowed';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALLOWED
     * @uses self::VALUE_LIMITED
     * @uses self::VALUE_DISALLOWED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALLOWED,
            self::VALUE_LIMITED,
            self::VALUE_DISALLOWED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
