<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getAffiliateSites
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AffiliateSiteFilter $options
     * @return AffiliateSites|bool
     */
    public function getAffiliateSites(\StructType\AffiliateSiteFilter $options)
    {
        try {
            $this->setResult(self::getSoapClient()->getAffiliateSites($options));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAffiliateSiteTypes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return AffiliateSiteTypes|bool
     */
    public function getAffiliateSiteTypes()
    {
        try {
            $this->setResult(self::getSoapClient()->getAffiliateSiteTypes());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAffiliateSiteCategories
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return AffiliateSiteCategories|bool
     */
    public function getAffiliateSiteCategories()
    {
        try {
            $this->setResult(self::getSoapClient()->getAffiliateSiteCategories());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCampaigns
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $affiliateSiteID
     * @param \StructType\CampaignFilter $options
     * @return Campaigns|bool
     */
    public function getCampaigns($affiliateSiteID, \StructType\CampaignFilter $options)
    {
        try {
            $this->setResult(self::getSoapClient()->getCampaigns($affiliateSiteID, $options));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCampaignCategories
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return CampaignCategories|bool
     */
    public function getCampaignCategories()
    {
        try {
            $this->setResult(self::getSoapClient()->getCampaignCategories());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCampaignCommissionExtended
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $affiliateSiteID
     * @param string $campaignID
     * @return \StructType\CampaignCommissionExtended|bool
     */
    public function getCampaignCommissionExtended($affiliateSiteID, $campaignID)
    {
        try {
            $this->setResult(self::getSoapClient()->getCampaignCommissionExtended($affiliateSiteID, $campaignID));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCampaignNewsItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CampaignNewsItemFilter $options
     * @return CampaignNewsItems|bool
     */
    public function getCampaignNewsItems(\StructType\CampaignNewsItemFilter $options)
    {
        try {
            $this->setResult(self::getSoapClient()->getCampaignNewsItems($options));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMaterialBannerDimensions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return MaterialBannerDimensions|bool
     */
    public function getMaterialBannerDimensions()
    {
        try {
            $this->setResult(self::getSoapClient()->getMaterialBannerDimensions());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMaterialBannerImageItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $affiliateSiteID
     * @param string $materialOutputType
     * @param \StructType\MaterialItemFilter $options
     * @return MaterialItems|bool
     */
    public function getMaterialBannerImageItems($affiliateSiteID, $materialOutputType, \StructType\MaterialItemFilter $options)
    {
        try {
            $this->setResult(self::getSoapClient()->getMaterialBannerImageItems($affiliateSiteID, $materialOutputType, $options));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMaterialBannerFlashItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $affiliateSiteID
     * @param string $materialOutputType
     * @param \StructType\MaterialItemFilter $options
     * @return MaterialItems|bool
     */
    public function getMaterialBannerFlashItems($affiliateSiteID, $materialOutputType, \StructType\MaterialItemFilter $options)
    {
        try {
            $this->setResult(self::getSoapClient()->getMaterialBannerFlashItems($affiliateSiteID, $materialOutputType, $options));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMaterialTextItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $affiliateSiteID
     * @param string $materialOutputType
     * @param \StructType\MaterialItemFilter $options
     * @return MaterialItems|bool
     */
    public function getMaterialTextItems($affiliateSiteID, $materialOutputType, \StructType\MaterialItemFilter $options)
    {
        try {
            $this->setResult(self::getSoapClient()->getMaterialTextItems($affiliateSiteID, $materialOutputType, $options));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMaterialHTMLItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $affiliateSiteID
     * @param string $materialOutputType
     * @param \StructType\MaterialItemFilter $options
     * @return MaterialItems|bool
     */
    public function getMaterialHTMLItems($affiliateSiteID, $materialOutputType, \StructType\MaterialItemFilter $options)
    {
        try {
            $this->setResult(self::getSoapClient()->getMaterialHTMLItems($affiliateSiteID, $materialOutputType, $options));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMaterialIncentiveVoucherItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $affiliateSiteID
     * @param string $materialOutputType
     * @param \StructType\MaterialItemFilter $options
     * @return MaterialItems|bool
     */
    public function getMaterialIncentiveVoucherItems($affiliateSiteID, $materialOutputType, \StructType\MaterialItemFilter $options)
    {
        try {
            $this->setResult(self::getSoapClient()->getMaterialIncentiveVoucherItems($affiliateSiteID, $materialOutputType, $options));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMaterialIncentiveOfferItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $affiliateSiteID
     * @param string $materialOutputType
     * @param \StructType\MaterialItemFilter $options
     * @return MaterialItems|bool
     */
    public function getMaterialIncentiveOfferItems($affiliateSiteID, $materialOutputType, \StructType\MaterialItemFilter $options)
    {
        try {
            $this->setResult(self::getSoapClient()->getMaterialIncentiveOfferItems($affiliateSiteID, $materialOutputType, $options));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getClickTransactions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $affiliateSiteID
     * @param \StructType\ClickTransactionFilter $options
     * @return ClickTransactions|bool
     */
    public function getClickTransactions($affiliateSiteID, \StructType\ClickTransactionFilter $options)
    {
        try {
            $this->setResult(self::getSoapClient()->getClickTransactions($affiliateSiteID, $options));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getConversionTransactions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $affiliateSiteID
     * @param \StructType\ConversionTransactionFilter $options
     * @return ConversionTransactions|bool
     */
    public function getConversionTransactions($affiliateSiteID, \StructType\ConversionTransactionFilter $options)
    {
        try {
            $this->setResult(self::getSoapClient()->getConversionTransactions($affiliateSiteID, $options));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getReportAffiliateSite
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $affiliateSiteID
     * @param \StructType\ReportAffiliateSiteFilter $options
     * @return \StructType\ReportData|bool
     */
    public function getReportAffiliateSite($affiliateSiteID, \StructType\ReportAffiliateSiteFilter $options)
    {
        try {
            $this->setResult(self::getSoapClient()->getReportAffiliateSite($affiliateSiteID, $options));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getReportCampaign
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $affiliateSiteID
     * @param \StructType\ReportCampaignFilter $options
     * @return ReportCampaign|bool
     */
    public function getReportCampaign($affiliateSiteID, \StructType\ReportCampaignFilter $options)
    {
        try {
            $this->setResult(self::getSoapClient()->getReportCampaign($affiliateSiteID, $options));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getReportReference
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $affiliateSiteID
     * @param \StructType\ReportReferenceFilter $options
     * @return ReportReference|bool
     */
    public function getReportReference($affiliateSiteID, \StructType\ReportReferenceFilter $options)
    {
        try {
            $this->setResult(self::getSoapClient()->getReportReference($affiliateSiteID, $options));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFeeds
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $affiliateSiteID
     * @param \StructType\FeedFilter $options
     * @return Feeds|bool
     */
    public function getFeeds($affiliateSiteID, \StructType\FeedFilter $options)
    {
        try {
            $this->setResult(self::getSoapClient()->getFeeds($affiliateSiteID, $options));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFeedProductCategories
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $affiliateSiteID
     * @param string $feedID
     * @return FeedCategories|bool
     */
    public function getFeedProductCategories($affiliateSiteID, $feedID)
    {
        try {
            $this->setResult(self::getSoapClient()->getFeedProductCategories($affiliateSiteID, $feedID));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFeedProducts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $affiliateSiteID
     * @param \StructType\FeedProductFilter $options
     * @return FeedProducts|bool
     */
    public function getFeedProducts($affiliateSiteID, \StructType\FeedProductFilter $options)
    {
        try {
            $this->setResult(self::getSoapClient()->getFeedProducts($affiliateSiteID, $options));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getPayments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PaymentFilter $options
     * @return Payments|bool
     */
    public function getPayments(\StructType\PaymentFilter $options)
    {
        try {
            $this->setResult(self::getSoapClient()->getPayments($options));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAttributions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $conversionTransactionID
     * @return \StructType\Attributions|bool
     */
    public function getAttributions($conversionTransactionID)
    {
        try {
            $this->setResult(self::getSoapClient()->getAttributions($conversionTransactionID));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return AffiliateSiteCategories|AffiliateSites|AffiliateSiteTypes|CampaignCategories|CampaignNewsItems|Campaigns|ClickTransactions|ConversionTransactions|FeedCategories|FeedProducts|Feeds|MaterialBannerDimensions|MaterialItems|Payments|ReportCampaign|ReportReference|\StructType\Attributions|\StructType\CampaignCommissionExtended|\StructType\ReportData
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
