<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FeedFilter StructType
 * @subpackage Structs
 */
class FeedFilter extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ID;
    /**
     * The campaignID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $campaignID;
    /**
     * The campaignCategoryID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $campaignCategoryID;
    /**
     * The assignmentStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $assignmentStatus;
    /**
     * Constructor method for FeedFilter
     * @uses FeedFilter::setID()
     * @uses FeedFilter::setCampaignID()
     * @uses FeedFilter::setCampaignCategoryID()
     * @uses FeedFilter::setAssignmentStatus()
     * @param int $iD
     * @param int $campaignID
     * @param int $campaignCategoryID
     * @param string $assignmentStatus
     */
    public function __construct($iD = null, $campaignID = null, $campaignCategoryID = null, $assignmentStatus = null)
    {
        $this
            ->setID($iD)
            ->setCampaignID($campaignID)
            ->setCampaignCategoryID($campaignCategoryID)
            ->setAssignmentStatus($assignmentStatus);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\FeedFilter
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get campaignID value
     * @return int|null
     */
    public function getCampaignID()
    {
        return $this->campaignID;
    }
    /**
     * Set campaignID value
     * @param int $campaignID
     * @return \StructType\FeedFilter
     */
    public function setCampaignID($campaignID = null)
    {
        // validation for constraint: int
        if (!is_null($campaignID) && !(is_int($campaignID) || ctype_digit($campaignID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($campaignID, true), gettype($campaignID)), __LINE__);
        }
        $this->campaignID = $campaignID;
        return $this;
    }
    /**
     * Get campaignCategoryID value
     * @return int|null
     */
    public function getCampaignCategoryID()
    {
        return $this->campaignCategoryID;
    }
    /**
     * Set campaignCategoryID value
     * @param int $campaignCategoryID
     * @return \StructType\FeedFilter
     */
    public function setCampaignCategoryID($campaignCategoryID = null)
    {
        // validation for constraint: int
        if (!is_null($campaignCategoryID) && !(is_int($campaignCategoryID) || ctype_digit($campaignCategoryID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($campaignCategoryID, true), gettype($campaignCategoryID)), __LINE__);
        }
        $this->campaignCategoryID = $campaignCategoryID;
        return $this;
    }
    /**
     * Get assignmentStatus value
     * @return string|null
     */
    public function getAssignmentStatus()
    {
        return $this->assignmentStatus;
    }
    /**
     * Set assignmentStatus value
     * @uses \EnumType\CampaignAssignmentStatus::valueIsValid()
     * @uses \EnumType\CampaignAssignmentStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $assignmentStatus
     * @return \StructType\FeedFilter
     */
    public function setAssignmentStatus($assignmentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CampaignAssignmentStatus::valueIsValid($assignmentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CampaignAssignmentStatus', is_array($assignmentStatus) ? implode(', ', $assignmentStatus) : var_export($assignmentStatus, true), implode(', ', \EnumType\CampaignAssignmentStatus::getValidValues())), __LINE__);
        }
        $this->assignmentStatus = $assignmentStatus;
        return $this;
    }
}
