<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Change ServiceType
 * @subpackage Services
 */
class Change extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named changeCampaignSubscription
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $affiliateSiteID
     * @param string $campaignID
     * @param string $subscriptionAction
     * @return void|bool
     */
    public function changeCampaignSubscription($affiliateSiteID, $campaignID, $subscriptionAction)
    {
        try {
            $this->setResult($this->getSoapClient()->changeCampaignSubscription($affiliateSiteID, $campaignID, $subscriptionAction));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return void
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
