<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://ws.tradetracker.com/soap/affiliate?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://ws.tradetracker.com/soap/affiliate?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Authenticate ServiceType
 */
$authenticate = new \ServiceType\Authenticate($options);
/**
 * Sample call for authenticate operation/method
 */
if ($authenticate->authenticate($customerID, $passphrase, $sandbox, $locale, $demo) !== false) {
    print_r($authenticate->getResult());
} else {
    print_r($authenticate->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getAffiliateSites operation/method
 */
if ($get->getAffiliateSites(new \StructType\AffiliateSiteFilter()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAffiliateSiteTypes operation/method
 */
if ($get->getAffiliateSiteTypes() !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAffiliateSiteCategories operation/method
 */
if ($get->getAffiliateSiteCategories() !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCampaigns operation/method
 */
if ($get->getCampaigns($affiliateSiteID, new \StructType\CampaignFilter()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCampaignCategories operation/method
 */
if ($get->getCampaignCategories() !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCampaignCommissionExtended operation/method
 */
if ($get->getCampaignCommissionExtended($affiliateSiteID, $campaignID) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCampaignNewsItems operation/method
 */
if ($get->getCampaignNewsItems(new \StructType\CampaignNewsItemFilter()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getMaterialBannerDimensions operation/method
 */
if ($get->getMaterialBannerDimensions() !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getMaterialBannerImageItems operation/method
 */
if ($get->getMaterialBannerImageItems($affiliateSiteID, $materialOutputType, new \StructType\MaterialItemFilter()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getMaterialBannerFlashItems operation/method
 */
if ($get->getMaterialBannerFlashItems($affiliateSiteID, $materialOutputType, new \StructType\MaterialItemFilter()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getMaterialTextItems operation/method
 */
if ($get->getMaterialTextItems($affiliateSiteID, $materialOutputType, new \StructType\MaterialItemFilter()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getMaterialHTMLItems operation/method
 */
if ($get->getMaterialHTMLItems($affiliateSiteID, $materialOutputType, new \StructType\MaterialItemFilter()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getMaterialIncentiveVoucherItems operation/method
 */
if ($get->getMaterialIncentiveVoucherItems($affiliateSiteID, $materialOutputType, new \StructType\MaterialItemFilter()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getMaterialIncentiveOfferItems operation/method
 */
if ($get->getMaterialIncentiveOfferItems($affiliateSiteID, $materialOutputType, new \StructType\MaterialItemFilter()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getClickTransactions operation/method
 */
if ($get->getClickTransactions($affiliateSiteID, new \StructType\ClickTransactionFilter()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getConversionTransactions operation/method
 */
if ($get->getConversionTransactions($affiliateSiteID, new \StructType\ConversionTransactionFilter()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getReportAffiliateSite operation/method
 */
if ($get->getReportAffiliateSite($affiliateSiteID, new \StructType\ReportAffiliateSiteFilter()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getReportAffiliateSites operation/method
 */
if ($get->getReportAffiliateSites($affiliateSiteIDs, new \StructType\ReportAffiliateSitesFilter()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getReportCampaign operation/method
 */
if ($get->getReportCampaign($affiliateSiteID, new \StructType\ReportCampaignFilter()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getReportReference operation/method
 */
if ($get->getReportReference($affiliateSiteID, new \StructType\ReportReferenceFilter()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getFeeds operation/method
 */
if ($get->getFeeds($affiliateSiteID, new \StructType\FeedFilter()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getFeedProductCategories operation/method
 */
if ($get->getFeedProductCategories($affiliateSiteID, $feedID) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getFeedProducts operation/method
 */
if ($get->getFeedProducts($affiliateSiteID, new \StructType\FeedProductFilter()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPayments operation/method
 */
if ($get->getPayments(new \StructType\PaymentFilter()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAttributions operation/method
 */
if ($get->getAttributions($conversionTransactionID) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getTouchpoints operation/method
 */
if ($get->getTouchpoints($conversionTransactionID) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Change ServiceType
 */
$change = new \ServiceType\Change($options);
/**
 * Sample call for changeCampaignSubscription operation/method
 */
if ($change->changeCampaignSubscription($affiliateSiteID, $campaignID, $subscriptionAction) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
/**
 * Sample call for createConversionTransaction operation/method
 */
if ($create->createConversionTransaction($transactionType, $affiliateSiteID, new \StructType\CreateConversionTransactionOptions()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
