<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for MaterialOutputType EnumType
 * @subpackage Enumerations
 */
class MaterialOutputType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'html'
     * @return string 'html'
     */
    const VALUE_HTML = 'html';
    /**
     * Constant for value 'javascript'
     * @return string 'javascript'
     */
    const VALUE_JAVASCRIPT = 'javascript';
    /**
     * Constant for value 'iframe'
     * @return string 'iframe'
     */
    const VALUE_IFRAME = 'iframe';
    /**
     * Constant for value 'popup'
     * @return string 'popup'
     */
    const VALUE_POPUP = 'popup';
    /**
     * Constant for value 'popunder'
     * @return string 'popunder'
     */
    const VALUE_POPUNDER = 'popunder';
    /**
     * Constant for value 'rss'
     * @return string 'rss'
     */
    const VALUE_RSS = 'rss';
    /**
     * Return allowed values
     * @uses self::VALUE_HTML
     * @uses self::VALUE_JAVASCRIPT
     * @uses self::VALUE_IFRAME
     * @uses self::VALUE_POPUP
     * @uses self::VALUE_POPUNDER
     * @uses self::VALUE_RSS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_HTML,
            self::VALUE_JAVASCRIPT,
            self::VALUE_IFRAME,
            self::VALUE_POPUP,
            self::VALUE_POPUNDER,
            self::VALUE_RSS,
        );
    }
}
