<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReportDataGroup StructType
 * @subpackage Structs
 */
class ReportDataGroup extends AbstractStructBase
{
    /**
     * The affiliateSiteID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $affiliateSiteID;
    /**
     * The overallImpressionCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $overallImpressionCount;
    /**
     * The uniqueImpressionCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $uniqueImpressionCount;
    /**
     * The impressionCommission
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var float
     */
    public $impressionCommission;
    /**
     * The overallClickCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $overallClickCount;
    /**
     * The uniqueClickCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $uniqueClickCount;
    /**
     * The clickCommission
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var float
     */
    public $clickCommission;
    /**
     * The leadCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $leadCount;
    /**
     * The leadCommission
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var float
     */
    public $leadCommission;
    /**
     * The saleCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $saleCount;
    /**
     * The saleCommission
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var float
     */
    public $saleCommission;
    /**
     * The fixedCommission
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var float
     */
    public $fixedCommission;
    /**
     * The CTR
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var float
     */
    public $CTR;
    /**
     * The CLR
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var float
     */
    public $CLR;
    /**
     * The CSR
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var float
     */
    public $CSR;
    /**
     * The eCPM
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var float
     */
    public $eCPM;
    /**
     * The EPC
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var float
     */
    public $EPC;
    /**
     * The totalCommission
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var float
     */
    public $totalCommission;
    /**
     * The date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $date;
    /**
     * The dateRange
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $dateRange;
    /**
     * Constructor method for ReportDataGroup
     * @uses ReportDataGroup::setAffiliateSiteID()
     * @uses ReportDataGroup::setOverallImpressionCount()
     * @uses ReportDataGroup::setUniqueImpressionCount()
     * @uses ReportDataGroup::setImpressionCommission()
     * @uses ReportDataGroup::setOverallClickCount()
     * @uses ReportDataGroup::setUniqueClickCount()
     * @uses ReportDataGroup::setClickCommission()
     * @uses ReportDataGroup::setLeadCount()
     * @uses ReportDataGroup::setLeadCommission()
     * @uses ReportDataGroup::setSaleCount()
     * @uses ReportDataGroup::setSaleCommission()
     * @uses ReportDataGroup::setFixedCommission()
     * @uses ReportDataGroup::setCTR()
     * @uses ReportDataGroup::setCLR()
     * @uses ReportDataGroup::setCSR()
     * @uses ReportDataGroup::setECPM()
     * @uses ReportDataGroup::setEPC()
     * @uses ReportDataGroup::setTotalCommission()
     * @uses ReportDataGroup::setDate()
     * @uses ReportDataGroup::setDateRange()
     * @param int $affiliateSiteID
     * @param int $overallImpressionCount
     * @param int $uniqueImpressionCount
     * @param float $impressionCommission
     * @param int $overallClickCount
     * @param int $uniqueClickCount
     * @param float $clickCommission
     * @param int $leadCount
     * @param float $leadCommission
     * @param int $saleCount
     * @param float $saleCommission
     * @param float $fixedCommission
     * @param float $cTR
     * @param float $cLR
     * @param float $cSR
     * @param float $eCPM
     * @param float $ePC
     * @param float $totalCommission
     * @param int $date
     * @param string $dateRange
     */
    public function __construct($affiliateSiteID = null, $overallImpressionCount = null, $uniqueImpressionCount = null, $impressionCommission = null, $overallClickCount = null, $uniqueClickCount = null, $clickCommission = null, $leadCount = null, $leadCommission = null, $saleCount = null, $saleCommission = null, $fixedCommission = null, $cTR = null, $cLR = null, $cSR = null, $eCPM = null, $ePC = null, $totalCommission = null, $date = null, $dateRange = null)
    {
        $this
            ->setAffiliateSiteID($affiliateSiteID)
            ->setOverallImpressionCount($overallImpressionCount)
            ->setUniqueImpressionCount($uniqueImpressionCount)
            ->setImpressionCommission($impressionCommission)
            ->setOverallClickCount($overallClickCount)
            ->setUniqueClickCount($uniqueClickCount)
            ->setClickCommission($clickCommission)
            ->setLeadCount($leadCount)
            ->setLeadCommission($leadCommission)
            ->setSaleCount($saleCount)
            ->setSaleCommission($saleCommission)
            ->setFixedCommission($fixedCommission)
            ->setCTR($cTR)
            ->setCLR($cLR)
            ->setCSR($cSR)
            ->setECPM($eCPM)
            ->setEPC($ePC)
            ->setTotalCommission($totalCommission)
            ->setDate($date)
            ->setDateRange($dateRange);
    }
    /**
     * Get affiliateSiteID value
     * @return int|null
     */
    public function getAffiliateSiteID()
    {
        return $this->affiliateSiteID;
    }
    /**
     * Set affiliateSiteID value
     * @param int $affiliateSiteID
     * @return \StructType\ReportDataGroup
     */
    public function setAffiliateSiteID($affiliateSiteID = null)
    {
        // validation for constraint: int
        if (!is_null($affiliateSiteID) && !(is_int($affiliateSiteID) || ctype_digit($affiliateSiteID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($affiliateSiteID, true), gettype($affiliateSiteID)), __LINE__);
        }
        $this->affiliateSiteID = $affiliateSiteID;
        return $this;
    }
    /**
     * Get overallImpressionCount value
     * @return int|null
     */
    public function getOverallImpressionCount()
    {
        return $this->overallImpressionCount;
    }
    /**
     * Set overallImpressionCount value
     * @param int $overallImpressionCount
     * @return \StructType\ReportDataGroup
     */
    public function setOverallImpressionCount($overallImpressionCount = null)
    {
        // validation for constraint: int
        if (!is_null($overallImpressionCount) && !(is_int($overallImpressionCount) || ctype_digit($overallImpressionCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($overallImpressionCount, true), gettype($overallImpressionCount)), __LINE__);
        }
        $this->overallImpressionCount = $overallImpressionCount;
        return $this;
    }
    /**
     * Get uniqueImpressionCount value
     * @return int|null
     */
    public function getUniqueImpressionCount()
    {
        return $this->uniqueImpressionCount;
    }
    /**
     * Set uniqueImpressionCount value
     * @param int $uniqueImpressionCount
     * @return \StructType\ReportDataGroup
     */
    public function setUniqueImpressionCount($uniqueImpressionCount = null)
    {
        // validation for constraint: int
        if (!is_null($uniqueImpressionCount) && !(is_int($uniqueImpressionCount) || ctype_digit($uniqueImpressionCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($uniqueImpressionCount, true), gettype($uniqueImpressionCount)), __LINE__);
        }
        $this->uniqueImpressionCount = $uniqueImpressionCount;
        return $this;
    }
    /**
     * Get impressionCommission value
     * @return float|null
     */
    public function getImpressionCommission()
    {
        return $this->impressionCommission;
    }
    /**
     * Set impressionCommission value
     * @param float $impressionCommission
     * @return \StructType\ReportDataGroup
     */
    public function setImpressionCommission($impressionCommission = null)
    {
        // validation for constraint: float
        if (!is_null($impressionCommission) && !(is_float($impressionCommission) || is_numeric($impressionCommission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($impressionCommission, true), gettype($impressionCommission)), __LINE__);
        }
        $this->impressionCommission = $impressionCommission;
        return $this;
    }
    /**
     * Get overallClickCount value
     * @return int|null
     */
    public function getOverallClickCount()
    {
        return $this->overallClickCount;
    }
    /**
     * Set overallClickCount value
     * @param int $overallClickCount
     * @return \StructType\ReportDataGroup
     */
    public function setOverallClickCount($overallClickCount = null)
    {
        // validation for constraint: int
        if (!is_null($overallClickCount) && !(is_int($overallClickCount) || ctype_digit($overallClickCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($overallClickCount, true), gettype($overallClickCount)), __LINE__);
        }
        $this->overallClickCount = $overallClickCount;
        return $this;
    }
    /**
     * Get uniqueClickCount value
     * @return int|null
     */
    public function getUniqueClickCount()
    {
        return $this->uniqueClickCount;
    }
    /**
     * Set uniqueClickCount value
     * @param int $uniqueClickCount
     * @return \StructType\ReportDataGroup
     */
    public function setUniqueClickCount($uniqueClickCount = null)
    {
        // validation for constraint: int
        if (!is_null($uniqueClickCount) && !(is_int($uniqueClickCount) || ctype_digit($uniqueClickCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($uniqueClickCount, true), gettype($uniqueClickCount)), __LINE__);
        }
        $this->uniqueClickCount = $uniqueClickCount;
        return $this;
    }
    /**
     * Get clickCommission value
     * @return float|null
     */
    public function getClickCommission()
    {
        return $this->clickCommission;
    }
    /**
     * Set clickCommission value
     * @param float $clickCommission
     * @return \StructType\ReportDataGroup
     */
    public function setClickCommission($clickCommission = null)
    {
        // validation for constraint: float
        if (!is_null($clickCommission) && !(is_float($clickCommission) || is_numeric($clickCommission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($clickCommission, true), gettype($clickCommission)), __LINE__);
        }
        $this->clickCommission = $clickCommission;
        return $this;
    }
    /**
     * Get leadCount value
     * @return int|null
     */
    public function getLeadCount()
    {
        return $this->leadCount;
    }
    /**
     * Set leadCount value
     * @param int $leadCount
     * @return \StructType\ReportDataGroup
     */
    public function setLeadCount($leadCount = null)
    {
        // validation for constraint: int
        if (!is_null($leadCount) && !(is_int($leadCount) || ctype_digit($leadCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($leadCount, true), gettype($leadCount)), __LINE__);
        }
        $this->leadCount = $leadCount;
        return $this;
    }
    /**
     * Get leadCommission value
     * @return float|null
     */
    public function getLeadCommission()
    {
        return $this->leadCommission;
    }
    /**
     * Set leadCommission value
     * @param float $leadCommission
     * @return \StructType\ReportDataGroup
     */
    public function setLeadCommission($leadCommission = null)
    {
        // validation for constraint: float
        if (!is_null($leadCommission) && !(is_float($leadCommission) || is_numeric($leadCommission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($leadCommission, true), gettype($leadCommission)), __LINE__);
        }
        $this->leadCommission = $leadCommission;
        return $this;
    }
    /**
     * Get saleCount value
     * @return int|null
     */
    public function getSaleCount()
    {
        return $this->saleCount;
    }
    /**
     * Set saleCount value
     * @param int $saleCount
     * @return \StructType\ReportDataGroup
     */
    public function setSaleCount($saleCount = null)
    {
        // validation for constraint: int
        if (!is_null($saleCount) && !(is_int($saleCount) || ctype_digit($saleCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($saleCount, true), gettype($saleCount)), __LINE__);
        }
        $this->saleCount = $saleCount;
        return $this;
    }
    /**
     * Get saleCommission value
     * @return float|null
     */
    public function getSaleCommission()
    {
        return $this->saleCommission;
    }
    /**
     * Set saleCommission value
     * @param float $saleCommission
     * @return \StructType\ReportDataGroup
     */
    public function setSaleCommission($saleCommission = null)
    {
        // validation for constraint: float
        if (!is_null($saleCommission) && !(is_float($saleCommission) || is_numeric($saleCommission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($saleCommission, true), gettype($saleCommission)), __LINE__);
        }
        $this->saleCommission = $saleCommission;
        return $this;
    }
    /**
     * Get fixedCommission value
     * @return float|null
     */
    public function getFixedCommission()
    {
        return $this->fixedCommission;
    }
    /**
     * Set fixedCommission value
     * @param float $fixedCommission
     * @return \StructType\ReportDataGroup
     */
    public function setFixedCommission($fixedCommission = null)
    {
        // validation for constraint: float
        if (!is_null($fixedCommission) && !(is_float($fixedCommission) || is_numeric($fixedCommission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fixedCommission, true), gettype($fixedCommission)), __LINE__);
        }
        $this->fixedCommission = $fixedCommission;
        return $this;
    }
    /**
     * Get CTR value
     * @return float|null
     */
    public function getCTR()
    {
        return $this->CTR;
    }
    /**
     * Set CTR value
     * @param float $cTR
     * @return \StructType\ReportDataGroup
     */
    public function setCTR($cTR = null)
    {
        // validation for constraint: float
        if (!is_null($cTR) && !(is_float($cTR) || is_numeric($cTR))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cTR, true), gettype($cTR)), __LINE__);
        }
        $this->CTR = $cTR;
        return $this;
    }
    /**
     * Get CLR value
     * @return float|null
     */
    public function getCLR()
    {
        return $this->CLR;
    }
    /**
     * Set CLR value
     * @param float $cLR
     * @return \StructType\ReportDataGroup
     */
    public function setCLR($cLR = null)
    {
        // validation for constraint: float
        if (!is_null($cLR) && !(is_float($cLR) || is_numeric($cLR))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cLR, true), gettype($cLR)), __LINE__);
        }
        $this->CLR = $cLR;
        return $this;
    }
    /**
     * Get CSR value
     * @return float|null
     */
    public function getCSR()
    {
        return $this->CSR;
    }
    /**
     * Set CSR value
     * @param float $cSR
     * @return \StructType\ReportDataGroup
     */
    public function setCSR($cSR = null)
    {
        // validation for constraint: float
        if (!is_null($cSR) && !(is_float($cSR) || is_numeric($cSR))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cSR, true), gettype($cSR)), __LINE__);
        }
        $this->CSR = $cSR;
        return $this;
    }
    /**
     * Get eCPM value
     * @return float|null
     */
    public function getECPM()
    {
        return $this->eCPM;
    }
    /**
     * Set eCPM value
     * @param float $eCPM
     * @return \StructType\ReportDataGroup
     */
    public function setECPM($eCPM = null)
    {
        // validation for constraint: float
        if (!is_null($eCPM) && !(is_float($eCPM) || is_numeric($eCPM))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($eCPM, true), gettype($eCPM)), __LINE__);
        }
        $this->eCPM = $eCPM;
        return $this;
    }
    /**
     * Get EPC value
     * @return float|null
     */
    public function getEPC()
    {
        return $this->EPC;
    }
    /**
     * Set EPC value
     * @param float $ePC
     * @return \StructType\ReportDataGroup
     */
    public function setEPC($ePC = null)
    {
        // validation for constraint: float
        if (!is_null($ePC) && !(is_float($ePC) || is_numeric($ePC))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ePC, true), gettype($ePC)), __LINE__);
        }
        $this->EPC = $ePC;
        return $this;
    }
    /**
     * Get totalCommission value
     * @return float|null
     */
    public function getTotalCommission()
    {
        return $this->totalCommission;
    }
    /**
     * Set totalCommission value
     * @param float $totalCommission
     * @return \StructType\ReportDataGroup
     */
    public function setTotalCommission($totalCommission = null)
    {
        // validation for constraint: float
        if (!is_null($totalCommission) && !(is_float($totalCommission) || is_numeric($totalCommission))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalCommission, true), gettype($totalCommission)), __LINE__);
        }
        $this->totalCommission = $totalCommission;
        return $this;
    }
    /**
     * Get date value
     * @return int|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param int $date
     * @return \StructType\ReportDataGroup
     */
    public function setDate($date = null)
    {
        // validation for constraint: int
        if (!is_null($date) && !(is_int($date) || ctype_digit($date))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get dateRange value
     * @return string|null
     */
    public function getDateRange()
    {
        return $this->dateRange;
    }
    /**
     * Set dateRange value
     * @param string $dateRange
     * @return \StructType\ReportDataGroup
     */
    public function setDateRange($dateRange = null)
    {
        // validation for constraint: string
        if (!is_null($dateRange) && !is_string($dateRange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateRange, true), gettype($dateRange)), __LINE__);
        }
        $this->dateRange = $dateRange;
        return $this;
    }
}
