<?php

namespace EnumType;

/**
 * This class stands for TransactionStatus EnumType
 * @subpackage Enumerations
 */
class TransactionStatus
{
    /**
     * Constant for value 'pending'
     * @return string 'pending'
     */
    const VALUE_PENDING = 'pending';
    /**
     * Constant for value 'accepted'
     * @return string 'accepted'
     */
    const VALUE_ACCEPTED = 'accepted';
    /**
     * Constant for value 'rejected'
     * @return string 'rejected'
     */
    const VALUE_REJECTED = 'rejected';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PENDING
     * @uses self::VALUE_ACCEPTED
     * @uses self::VALUE_REJECTED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PENDING,
            self::VALUE_ACCEPTED,
            self::VALUE_REJECTED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
