<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CampaignNewsItem StructType
 * @subpackage Structs
 */
class CampaignNewsItem extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $ID;
    /**
     * The campaign
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var \StructType\Campaign
     */
    public $campaign;
    /**
     * The campaignNewsType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $campaignNewsType;
    /**
     * The title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $title;
    /**
     * The content
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $content;
    /**
     * The publishDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $publishDate;
    /**
     * The expirationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $expirationDate;
    /**
     * Constructor method for CampaignNewsItem
     * @uses CampaignNewsItem::setID()
     * @uses CampaignNewsItem::setCampaign()
     * @uses CampaignNewsItem::setCampaignNewsType()
     * @uses CampaignNewsItem::setTitle()
     * @uses CampaignNewsItem::setContent()
     * @uses CampaignNewsItem::setPublishDate()
     * @uses CampaignNewsItem::setExpirationDate()
     * @param int $iD
     * @param \StructType\Campaign $campaign
     * @param string $campaignNewsType
     * @param string $title
     * @param string $content
     * @param string $publishDate
     * @param string $expirationDate
     */
    public function __construct($iD = null, \StructType\Campaign $campaign = null, $campaignNewsType = null, $title = null, $content = null, $publishDate = null, $expirationDate = null)
    {
        $this
            ->setID($iD)
            ->setCampaign($campaign)
            ->setCampaignNewsType($campaignNewsType)
            ->setTitle($title)
            ->setContent($content)
            ->setPublishDate($publishDate)
            ->setExpirationDate($expirationDate);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\CampaignNewsItem
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get campaign value
     * @return \StructType\Campaign|null
     */
    public function getCampaign()
    {
        return $this->campaign;
    }
    /**
     * Set campaign value
     * @param \StructType\Campaign $campaign
     * @return \StructType\CampaignNewsItem
     */
    public function setCampaign(\StructType\Campaign $campaign = null)
    {
        $this->campaign = $campaign;
        return $this;
    }
    /**
     * Get campaignNewsType value
     * @return string|null
     */
    public function getCampaignNewsType()
    {
        return $this->campaignNewsType;
    }
    /**
     * Set campaignNewsType value
     * @uses \EnumType\CampaignNewsType::valueIsValid()
     * @uses \EnumType\CampaignNewsType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $campaignNewsType
     * @return \StructType\CampaignNewsItem
     */
    public function setCampaignNewsType($campaignNewsType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CampaignNewsType::valueIsValid($campaignNewsType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $campaignNewsType, implode(', ', \EnumType\CampaignNewsType::getValidValues())), __LINE__);
        }
        $this->campaignNewsType = $campaignNewsType;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\CampaignNewsItem
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get content value
     * @return string|null
     */
    public function getContent()
    {
        return $this->content;
    }
    /**
     * Set content value
     * @param string $content
     * @return \StructType\CampaignNewsItem
     */
    public function setContent($content = null)
    {
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($content)), __LINE__);
        }
        $this->content = $content;
        return $this;
    }
    /**
     * Get publishDate value
     * @return string|null
     */
    public function getPublishDate()
    {
        return $this->publishDate;
    }
    /**
     * Set publishDate value
     * @param string $publishDate
     * @return \StructType\CampaignNewsItem
     */
    public function setPublishDate($publishDate = null)
    {
        // validation for constraint: string
        if (!is_null($publishDate) && !is_string($publishDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($publishDate)), __LINE__);
        }
        $this->publishDate = $publishDate;
        return $this;
    }
    /**
     * Get expirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->expirationDate;
    }
    /**
     * Set expirationDate value
     * @param string $expirationDate
     * @return \StructType\CampaignNewsItem
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expirationDate)), __LINE__);
        }
        $this->expirationDate = $expirationDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CampaignNewsItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
