<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReportReferenceFilter StructType
 * @subpackage Structs
 */
class ReportReferenceFilter extends AbstractStructBase
{
    /**
     * The reference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $reference;
    /**
     * The campaignID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var int
     */
    public $campaignID;
    /**
     * The dateFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $dateFrom;
    /**
     * The dateTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - nillable: true
     * @var string
     */
    public $dateTo;
    /**
     * Constructor method for ReportReferenceFilter
     * @uses ReportReferenceFilter::setReference()
     * @uses ReportReferenceFilter::setCampaignID()
     * @uses ReportReferenceFilter::setDateFrom()
     * @uses ReportReferenceFilter::setDateTo()
     * @param string $reference
     * @param int $campaignID
     * @param string $dateFrom
     * @param string $dateTo
     */
    public function __construct($reference = null, $campaignID = null, $dateFrom = null, $dateTo = null)
    {
        $this
            ->setReference($reference)
            ->setCampaignID($campaignID)
            ->setDateFrom($dateFrom)
            ->setDateTo($dateTo);
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \StructType\ReportReferenceFilter
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get campaignID value
     * @return int|null
     */
    public function getCampaignID()
    {
        return $this->campaignID;
    }
    /**
     * Set campaignID value
     * @param int $campaignID
     * @return \StructType\ReportReferenceFilter
     */
    public function setCampaignID($campaignID = null)
    {
        // validation for constraint: int
        if (!is_null($campaignID) && !(is_int($campaignID) || ctype_digit($campaignID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($campaignID, true), gettype($campaignID)), __LINE__);
        }
        $this->campaignID = $campaignID;
        return $this;
    }
    /**
     * Get dateFrom value
     * @return string|null
     */
    public function getDateFrom()
    {
        return $this->dateFrom;
    }
    /**
     * Set dateFrom value
     * @param string $dateFrom
     * @return \StructType\ReportReferenceFilter
     */
    public function setDateFrom($dateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($dateFrom) && !is_string($dateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateFrom, true), gettype($dateFrom)), __LINE__);
        }
        $this->dateFrom = $dateFrom;
        return $this;
    }
    /**
     * Get dateTo value
     * @return string|null
     */
    public function getDateTo()
    {
        return $this->dateTo;
    }
    /**
     * Set dateTo value
     * @param string $dateTo
     * @return \StructType\ReportReferenceFilter
     */
    public function setDateTo($dateTo = null)
    {
        // validation for constraint: string
        if (!is_null($dateTo) && !is_string($dateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTo, true), gettype($dateTo)), __LINE__);
        }
        $this->dateTo = $dateTo;
        return $this;
    }
}
