<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CampaignCategory StructType
 * @subpackage Structs
 */
class CampaignCategory extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var int
     */
    public $ID;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var string
     */
    public $name;
    /**
     * The categories
     * Meta information extracted from the WSDL
     * - arrayType: tns:CampaignCategory[]
     * - base: SOAP-ENC:Array
     * - maxOccurs: 1
     * - nillable: true
     * - ref: SOAP-ENC:arrayType
     * @var \StructType\CampaignCategory[]
     */
    public $categories;
    /**
     * Constructor method for CampaignCategory
     * @uses CampaignCategory::setID()
     * @uses CampaignCategory::setName()
     * @uses CampaignCategory::setCategories()
     * @param int $iD
     * @param string $name
     * @param \StructType\CampaignCategory[] $categories
     */
    public function __construct($iD = null, $name = null, array $categories = array())
    {
        $this
            ->setID($iD)
            ->setName($name)
            ->setCategories($categories);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\CampaignCategory
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\CampaignCategory
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get categories value
     * @return \StructType\CampaignCategory[]|null
     */
    public function getCategories()
    {
        return $this->categories;
    }
    /**
     * This method is responsible for validating the values passed to the setCategories method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCategories method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCategoriesForArrayConstraintsFromSetCategories(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $campaignCategoryCategoriesItem) {
            // validation for constraint: itemType
            if (!$campaignCategoryCategoriesItem instanceof \StructType\CampaignCategory) {
                $invalidValues[] = is_object($campaignCategoryCategoriesItem) ? get_class($campaignCategoryCategoriesItem) : sprintf('%s(%s)', gettype($campaignCategoryCategoriesItem), var_export($campaignCategoryCategoriesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The categories property can only contain items of type \StructType\CampaignCategory, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set categories value
     * @throws \InvalidArgumentException
     * @param \StructType\CampaignCategory[] $categories
     * @return \StructType\CampaignCategory
     */
    public function setCategories(array $categories = array())
    {
        // validation for constraint: array
        if ('' !== ($categoriesArrayErrorMessage = self::validateCategoriesForArrayConstraintsFromSetCategories($categories))) {
            throw new \InvalidArgumentException($categoriesArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($categories) && count($categories) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1', count($categories)), __LINE__);
        }
        $this->categories = $categories;
        return $this;
    }
    /**
     * Add item to categories value
     * @throws \InvalidArgumentException
     * @param \StructType\CampaignCategory $item
     * @return \StructType\CampaignCategory
     */
    public function addToCategories(\StructType\CampaignCategory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CampaignCategory) {
            throw new \InvalidArgumentException(sprintf('The categories property can only contain items of type \StructType\CampaignCategory, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($this->categories) && count($this->categories) >= 1) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1', count($this->categories)), __LINE__);
        }
        $this->categories[] = $item;
        return $this;
    }
}
