<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReportCampaignElement StructType
 * @subpackage Structs
 */
class ReportCampaignElement extends AbstractStructBase
{
    /**
     * The campaign
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var \StructType\Campaign
     */
    public $campaign;
    /**
     * The reportData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * @var \StructType\ReportData
     */
    public $reportData;
    /**
     * Constructor method for ReportCampaignElement
     * @uses ReportCampaignElement::setCampaign()
     * @uses ReportCampaignElement::setReportData()
     * @param \StructType\Campaign $campaign
     * @param \StructType\ReportData $reportData
     */
    public function __construct(\StructType\Campaign $campaign = null, \StructType\ReportData $reportData = null)
    {
        $this
            ->setCampaign($campaign)
            ->setReportData($reportData);
    }
    /**
     * Get campaign value
     * @return \StructType\Campaign|null
     */
    public function getCampaign()
    {
        return $this->campaign;
    }
    /**
     * Set campaign value
     * @param \StructType\Campaign $campaign
     * @return \StructType\ReportCampaignElement
     */
    public function setCampaign(\StructType\Campaign $campaign = null)
    {
        $this->campaign = $campaign;
        return $this;
    }
    /**
     * Get reportData value
     * @return \StructType\ReportData|null
     */
    public function getReportData()
    {
        return $this->reportData;
    }
    /**
     * Set reportData value
     * @param \StructType\ReportData $reportData
     * @return \StructType\ReportCampaignElement
     */
    public function setReportData(\StructType\ReportData $reportData = null)
    {
        $this->reportData = $reportData;
        return $this;
    }
}
